/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mpa.model.CancelSessionRequest;
import software.amazon.awssdk.services.mpa.model.CancelSessionResponse;
import software.amazon.awssdk.services.mpa.model.CreateApprovalTeamRequest;
import software.amazon.awssdk.services.mpa.model.CreateApprovalTeamResponse;
import software.amazon.awssdk.services.mpa.model.CreateIdentitySourceRequest;
import software.amazon.awssdk.services.mpa.model.CreateIdentitySourceResponse;
import software.amazon.awssdk.services.mpa.model.DeleteIdentitySourceRequest;
import software.amazon.awssdk.services.mpa.model.DeleteIdentitySourceResponse;
import software.amazon.awssdk.services.mpa.model.DeleteInactiveApprovalTeamVersionRequest;
import software.amazon.awssdk.services.mpa.model.DeleteInactiveApprovalTeamVersionResponse;
import software.amazon.awssdk.services.mpa.model.GetApprovalTeamRequest;
import software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponse;
import software.amazon.awssdk.services.mpa.model.GetIdentitySourceRequest;
import software.amazon.awssdk.services.mpa.model.GetIdentitySourceResponse;
import software.amazon.awssdk.services.mpa.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.mpa.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.mpa.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.mpa.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.mpa.model.GetSessionRequest;
import software.amazon.awssdk.services.mpa.model.GetSessionResponse;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest;
import software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponse;
import software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest;
import software.amazon.awssdk.services.mpa.model.ListIdentitySourcesResponse;
import software.amazon.awssdk.services.mpa.model.ListPoliciesRequest;
import software.amazon.awssdk.services.mpa.model.ListPoliciesResponse;
import software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.mpa.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponse;
import software.amazon.awssdk.services.mpa.model.ListSessionsRequest;
import software.amazon.awssdk.services.mpa.model.ListSessionsResponse;
import software.amazon.awssdk.services.mpa.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mpa.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mpa.model.StartActiveApprovalTeamDeletionRequest;
import software.amazon.awssdk.services.mpa.model.StartActiveApprovalTeamDeletionResponse;
import software.amazon.awssdk.services.mpa.model.TagResourceRequest;
import software.amazon.awssdk.services.mpa.model.TagResourceResponse;
import software.amazon.awssdk.services.mpa.model.UntagResourceRequest;
import software.amazon.awssdk.services.mpa.model.UntagResourceResponse;
import software.amazon.awssdk.services.mpa.model.UpdateApprovalTeamRequest;
import software.amazon.awssdk.services.mpa.model.UpdateApprovalTeamResponse;
import software.amazon.awssdk.services.mpa.paginators.ListApprovalTeamsPublisher;
import software.amazon.awssdk.services.mpa.paginators.ListIdentitySourcesPublisher;
import software.amazon.awssdk.services.mpa.paginators.ListPoliciesPublisher;
import software.amazon.awssdk.services.mpa.paginators.ListPolicyVersionsPublisher;
import software.amazon.awssdk.services.mpa.paginators.ListResourcePoliciesPublisher;
import software.amazon.awssdk.services.mpa.paginators.ListSessionsPublisher;

/**
 * Service client for accessing AWS Multi-party Approval asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Multi-party approval is a capability of <a href="http://aws.amazon.com/organizations">Organizations</a> that allows
 * you to protect a predefined list of operations through a distributed approval process. Use Multi-party approval to
 * establish approval workflows and transform security processes into team-based decisions.
 * </p>
 * <p>
 * <b>When to use Multi-party approval</b>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You need to align with the Zero Trust principle of "never trust, always verify"
 * </p>
 * </li>
 * <li>
 * <p>
 * You need to make sure that the right humans have access to the right things in the right way
 * </p>
 * </li>
 * <li>
 * <p>
 * You need distributed decision-making for sensitive or critical operations
 * </p>
 * </li>
 * <li>
 * <p>
 * You need to protect against unintended operations on sensitive or critical resources
 * </p>
 * </li>
 * <li>
 * <p>
 * You need formal reviews and approvals for auditing or compliance reasons
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/what-is.html">What is Multi-party
 * approval</a> in the <i>Multi-party approval User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MpaAsyncClient extends AwsClient {
    String SERVICE_NAME = "mpa";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mpa";

    /**
     * <p>
     * Cancels an approval session. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Session</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     *
     * @param cancelSessionRequest
     * @return A Java Future containing the result of the CancelSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.CancelSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/CancelSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelSessionResponse> cancelSession(CancelSessionRequest cancelSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an approval session. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Session</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSessionRequest.Builder} avoiding the need to
     * create one manually via {@link CancelSessionRequest#builder()}
     * </p>
     *
     * @param cancelSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.CancelSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.CancelSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/CancelSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelSessionResponse> cancelSession(Consumer<CancelSessionRequest.Builder> cancelSessionRequest) {
        return cancelSession(CancelSessionRequest.builder().applyMutation(cancelSessionRequest).build());
    }

    /**
     * <p>
     * Creates a new approval team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Approval team</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     *
     * @param createApprovalTeamRequest
     * @return A Java Future containing the result of the CreateApprovalTeam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for your account. Request a quota
     *         increase or reduce your request size.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.CreateApprovalTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/CreateApprovalTeam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApprovalTeamResponse> createApprovalTeam(CreateApprovalTeamRequest createApprovalTeamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new approval team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Approval team</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApprovalTeamRequest.Builder} avoiding the
     * need to create one manually via {@link CreateApprovalTeamRequest#builder()}
     * </p>
     *
     * @param createApprovalTeamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.CreateApprovalTeamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApprovalTeam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for your account. Request a quota
     *         increase or reduce your request size.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.CreateApprovalTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/CreateApprovalTeam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApprovalTeamResponse> createApprovalTeam(
            Consumer<CreateApprovalTeamRequest.Builder> createApprovalTeamRequest) {
        return createApprovalTeam(CreateApprovalTeamRequest.builder().applyMutation(createApprovalTeamRequest).build());
    }

    /**
     * <p>
     * Creates a new identity source. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param createIdentitySourceRequest
     * @return A Java Future containing the result of the CreateIdentitySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for your account. Request a quota
     *         increase or reduce your request size.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.CreateIdentitySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/CreateIdentitySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIdentitySourceResponse> createIdentitySource(
            CreateIdentitySourceRequest createIdentitySourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new identity source. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdentitySourceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIdentitySourceRequest#builder()}
     * </p>
     *
     * @param createIdentitySourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.CreateIdentitySourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIdentitySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for your account. Request a quota
     *         increase or reduce your request size.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.CreateIdentitySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/CreateIdentitySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIdentitySourceResponse> createIdentitySource(
            Consumer<CreateIdentitySourceRequest.Builder> createIdentitySourceRequest) {
        return createIdentitySource(CreateIdentitySourceRequest.builder().applyMutation(createIdentitySourceRequest).build());
    }

    /**
     * <p>
     * Deletes an identity source. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param deleteIdentitySourceRequest
     * @return A Java Future containing the result of the DeleteIdentitySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.DeleteIdentitySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/DeleteIdentitySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIdentitySourceResponse> deleteIdentitySource(
            DeleteIdentitySourceRequest deleteIdentitySourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an identity source. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentitySourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentitySourceRequest#builder()}
     * </p>
     *
     * @param deleteIdentitySourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.DeleteIdentitySourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIdentitySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.DeleteIdentitySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/DeleteIdentitySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIdentitySourceResponse> deleteIdentitySource(
            Consumer<DeleteIdentitySourceRequest.Builder> deleteIdentitySourceRequest) {
        return deleteIdentitySource(DeleteIdentitySourceRequest.builder().applyMutation(deleteIdentitySourceRequest).build());
    }

    /**
     * <p>
     * Deletes an inactive approval team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * You can also use this operation to delete a team draft. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/update-team.html#update-team-draft-status">Interacting
     * with drafts</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param deleteInactiveApprovalTeamVersionRequest
     * @return A Java Future containing the result of the DeleteInactiveApprovalTeamVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.DeleteInactiveApprovalTeamVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/DeleteInactiveApprovalTeamVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInactiveApprovalTeamVersionResponse> deleteInactiveApprovalTeamVersion(
            DeleteInactiveApprovalTeamVersionRequest deleteInactiveApprovalTeamVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inactive approval team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * You can also use this operation to delete a team draft. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/update-team.html#update-team-draft-status">Interacting
     * with drafts</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInactiveApprovalTeamVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInactiveApprovalTeamVersionRequest#builder()}
     * </p>
     *
     * @param deleteInactiveApprovalTeamVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.DeleteInactiveApprovalTeamVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteInactiveApprovalTeamVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.DeleteInactiveApprovalTeamVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/DeleteInactiveApprovalTeamVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInactiveApprovalTeamVersionResponse> deleteInactiveApprovalTeamVersion(
            Consumer<DeleteInactiveApprovalTeamVersionRequest.Builder> deleteInactiveApprovalTeamVersionRequest) {
        return deleteInactiveApprovalTeamVersion(DeleteInactiveApprovalTeamVersionRequest.builder()
                .applyMutation(deleteInactiveApprovalTeamVersionRequest).build());
    }

    /**
     * <p>
     * Returns details for an approval team.
     * </p>
     *
     * @param getApprovalTeamRequest
     * @return A Java Future containing the result of the GetApprovalTeam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetApprovalTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetApprovalTeam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApprovalTeamResponse> getApprovalTeam(GetApprovalTeamRequest getApprovalTeamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for an approval team.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApprovalTeamRequest.Builder} avoiding the need
     * to create one manually via {@link GetApprovalTeamRequest#builder()}
     * </p>
     *
     * @param getApprovalTeamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.GetApprovalTeamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApprovalTeam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetApprovalTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetApprovalTeam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApprovalTeamResponse> getApprovalTeam(
            Consumer<GetApprovalTeamRequest.Builder> getApprovalTeamRequest) {
        return getApprovalTeam(GetApprovalTeamRequest.builder().applyMutation(getApprovalTeamRequest).build());
    }

    /**
     * <p>
     * Returns details for an identity source. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param getIdentitySourceRequest
     * @return A Java Future containing the result of the GetIdentitySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetIdentitySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetIdentitySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIdentitySourceResponse> getIdentitySource(GetIdentitySourceRequest getIdentitySourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for an identity source. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentitySourceRequest.Builder} avoiding the need
     * to create one manually via {@link GetIdentitySourceRequest#builder()}
     * </p>
     *
     * @param getIdentitySourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.GetIdentitySourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetIdentitySource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetIdentitySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetIdentitySource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIdentitySourceResponse> getIdentitySource(
            Consumer<GetIdentitySourceRequest.Builder> getIdentitySourceRequest) {
        return getIdentitySource(GetIdentitySourceRequest.builder().applyMutation(getIdentitySourceRequest).build());
    }

    /**
     * <p>
     * Returns details for the version of a policy. Policies define the permissions for team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param getPolicyVersionRequest
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for the version of a policy. Policies define the permissions for team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPolicyVersionRequest#builder()}
     * </p>
     *
     * @param getPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.GetPolicyVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(
            Consumer<GetPolicyVersionRequest.Builder> getPolicyVersionRequest) {
        return getPolicyVersion(GetPolicyVersionRequest.builder().applyMutation(getPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Returns details about a policy for a resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidParameterException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a policy for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.GetResourcePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InvalidParameterException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns details for an approval session. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Session</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for an approval session. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Session</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.GetSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * Returns a list of approval teams.
     * </p>
     *
     * @param listApprovalTeamsRequest
     * @return A Java Future containing the result of the ListApprovalTeams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListApprovalTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListApprovalTeams" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApprovalTeamsResponse> listApprovalTeams(ListApprovalTeamsRequest listApprovalTeamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of approval teams.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovalTeamsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApprovalTeamsRequest#builder()}
     * </p>
     *
     * @param listApprovalTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListApprovalTeams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListApprovalTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListApprovalTeams" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApprovalTeamsResponse> listApprovalTeams(
            Consumer<ListApprovalTeamsRequest.Builder> listApprovalTeamsRequest) {
        return listApprovalTeams(ListApprovalTeamsRequest.builder().applyMutation(listApprovalTeamsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApprovalTeams(software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListApprovalTeamsPublisher publisher = client.listApprovalTeamsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListApprovalTeamsPublisher publisher = client.listApprovalTeamsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovalTeams(software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest)} operation.</b>
     * </p>
     *
     * @param listApprovalTeamsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListApprovalTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListApprovalTeams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApprovalTeamsPublisher listApprovalTeamsPaginator(ListApprovalTeamsRequest listApprovalTeamsRequest) {
        return new ListApprovalTeamsPublisher(this, listApprovalTeamsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApprovalTeams(software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListApprovalTeamsPublisher publisher = client.listApprovalTeamsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListApprovalTeamsPublisher publisher = client.listApprovalTeamsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListApprovalTeamsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovalTeams(software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovalTeamsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApprovalTeamsRequest#builder()}
     * </p>
     *
     * @param listApprovalTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListApprovalTeamsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListApprovalTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListApprovalTeams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApprovalTeamsPublisher listApprovalTeamsPaginator(
            Consumer<ListApprovalTeamsRequest.Builder> listApprovalTeamsRequest) {
        return listApprovalTeamsPaginator(ListApprovalTeamsRequest.builder().applyMutation(listApprovalTeamsRequest).build());
    }

    /**
     * <p>
     * Returns a list of identity sources. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param listIdentitySourcesRequest
     * @return A Java Future containing the result of the ListIdentitySources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListIdentitySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListIdentitySources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIdentitySourcesResponse> listIdentitySources(
            ListIdentitySourcesRequest listIdentitySourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of identity sources. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the
     * <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentitySourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentitySourcesRequest#builder()}
     * </p>
     *
     * @param listIdentitySourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIdentitySources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListIdentitySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListIdentitySources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIdentitySourcesResponse> listIdentitySources(
            Consumer<ListIdentitySourcesRequest.Builder> listIdentitySourcesRequest) {
        return listIdentitySources(ListIdentitySourcesRequest.builder().applyMutation(listIdentitySourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentitySources(software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListIdentitySourcesPublisher publisher = client.listIdentitySourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListIdentitySourcesPublisher publisher = client.listIdentitySourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListIdentitySourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListIdentitySourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentitySources(software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest)} operation.</b>
     * </p>
     *
     * @param listIdentitySourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListIdentitySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListIdentitySources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitySourcesPublisher listIdentitySourcesPaginator(ListIdentitySourcesRequest listIdentitySourcesRequest) {
        return new ListIdentitySourcesPublisher(this, listIdentitySourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentitySources(software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListIdentitySourcesPublisher publisher = client.listIdentitySourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListIdentitySourcesPublisher publisher = client.listIdentitySourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListIdentitySourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListIdentitySourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentitySources(software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentitySourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentitySourcesRequest#builder()}
     * </p>
     *
     * @param listIdentitySourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListIdentitySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListIdentitySources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitySourcesPublisher listIdentitySourcesPaginator(
            Consumer<ListIdentitySourcesRequest.Builder> listIdentitySourcesRequest) {
        return listIdentitySourcesPaginator(ListIdentitySourcesRequest.builder().applyMutation(listIdentitySourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of policies. Policies define the permissions for team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param listPoliciesRequest
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of policies. Policies define the permissions for team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListPoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest) {
        return listPolicies(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.mpa.model.ListPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.mpa.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesPublisher listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) {
        return new ListPoliciesPublisher(this, listPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.mpa.model.ListPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.mpa.model.ListPoliciesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListPoliciesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesPublisher listPoliciesPaginator(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest) {
        return listPoliciesPaginator(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the versions for policies. Policies define the permissions for team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the versions for policies. Policies define the permissions for team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(
            Consumer<ListPolicyVersionsRequest.Builder> listPolicyVersionsRequest) {
        return listPolicyVersions(ListPolicyVersionsRequest.builder().applyMutation(listPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyVersions(software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListPolicyVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListPolicyVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyVersions(software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsPublisher listPolicyVersionsPaginator(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        return new ListPolicyVersionsPublisher(this, listPolicyVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyVersions(software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListPolicyVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListPolicyVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyVersions(software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsPublisher listPolicyVersionsPaginator(
            Consumer<ListPolicyVersionsRequest.Builder> listPolicyVersionsRequest) {
        return listPolicyVersionsPaginator(ListPolicyVersionsRequest.builder().applyMutation(listPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of policies for a resource.
     * </p>
     *
     * @param listResourcePoliciesRequest
     * @return A Java Future containing the result of the ListResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcePoliciesResponse> listResourcePolicies(
            ListResourcePoliciesRequest listResourcePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of policies for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param listResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcePoliciesResponse> listResourcePolicies(
            Consumer<ListResourcePoliciesRequest.Builder> listResourcePoliciesRequest) {
        return listResourcePolicies(ListResourcePoliciesRequest.builder().applyMutation(listResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourcePolicies(software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListResourcePoliciesPublisher publisher = client.listResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListResourcePoliciesPublisher publisher = client.listResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcePolicies(software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcePoliciesPublisher listResourcePoliciesPaginator(ListResourcePoliciesRequest listResourcePoliciesRequest) {
        return new ListResourcePoliciesPublisher(this, listResourcePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourcePolicies(software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListResourcePoliciesPublisher publisher = client.listResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListResourcePoliciesPublisher publisher = client.listResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcePolicies(software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param listResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcePoliciesPublisher listResourcePoliciesPaginator(
            Consumer<ListResourcePoliciesRequest.Builder> listResourcePoliciesRequest) {
        return listResourcePoliciesPaginator(ListResourcePoliciesRequest.builder().applyMutation(listResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of approval sessions. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Session</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     *
     * @param listSessionsRequest
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of approval sessions. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Session</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListSessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.mpa.model.ListSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.mpa.model.ListSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(ListSessionsRequest listSessionsRequest) {
        return new ListSessionsPublisher(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.mpa.model.ListSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mpa.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mpa.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mpa.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.mpa.model.ListSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListSessionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the deletion process for an active approval team.
     * </p>
     * <note>
     * <p>
     * <b>Deletions require team approval</b>
     * </p>
     * <p>
     * Requests to delete an active team must be approved by the team.
     * </p>
     * </note>
     *
     * @param startActiveApprovalTeamDeletionRequest
     * @return A Java Future containing the result of the StartActiveApprovalTeamDeletion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.StartActiveApprovalTeamDeletion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/StartActiveApprovalTeamDeletion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartActiveApprovalTeamDeletionResponse> startActiveApprovalTeamDeletion(
            StartActiveApprovalTeamDeletionRequest startActiveApprovalTeamDeletionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the deletion process for an active approval team.
     * </p>
     * <note>
     * <p>
     * <b>Deletions require team approval</b>
     * </p>
     * <p>
     * Requests to delete an active team must be approved by the team.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartActiveApprovalTeamDeletionRequest.Builder}
     * avoiding the need to create one manually via {@link StartActiveApprovalTeamDeletionRequest#builder()}
     * </p>
     *
     * @param startActiveApprovalTeamDeletionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.StartActiveApprovalTeamDeletionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartActiveApprovalTeamDeletion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.StartActiveApprovalTeamDeletion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/StartActiveApprovalTeamDeletion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartActiveApprovalTeamDeletionResponse> startActiveApprovalTeamDeletion(
            Consumer<StartActiveApprovalTeamDeletionRequest.Builder> startActiveApprovalTeamDeletionRequest) {
        return startActiveApprovalTeamDeletion(StartActiveApprovalTeamDeletionRequest.builder()
                .applyMutation(startActiveApprovalTeamDeletionRequest).build());
    }

    /**
     * <p>
     * Creates or updates a resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help
     * you manage, identify, organize, search for, and filter resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>TooManyTagsException The request exceeds the maximum number of tags allowed for this resource. Remove
     *         some tags, and try again.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help
     * you manage, identify, organize, search for, and filter resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>TooManyTagsException The request exceeds the maximum number of tags allowed for this resource. Remove
     *         some tags, and try again.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help you manage,
     * identify, organize, search for, and filter resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help you manage,
     * identify, organize, search for, and filter resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an approval team. You can request to update the team description, approval threshold, and approvers in
     * the team.
     * </p>
     * <note>
     * <p>
     * <b>Updates require team approval</b>
     * </p>
     * <p>
     * Updates to an active team must be approved by the team.
     * </p>
     * </note>
     *
     * @param updateApprovalTeamRequest
     * @return A Java Future containing the result of the UpdateApprovalTeam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for your account. Request a quota
     *         increase or reduce your request size.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.UpdateApprovalTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/UpdateApprovalTeam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApprovalTeamResponse> updateApprovalTeam(UpdateApprovalTeamRequest updateApprovalTeamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an approval team. You can request to update the team description, approval threshold, and approvers in
     * the team.
     * </p>
     * <note>
     * <p>
     * <b>Updates require team approval</b>
     * </p>
     * <p>
     * Updates to an active team must be approved by the team.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApprovalTeamRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateApprovalTeamRequest#builder()}
     * </p>
     *
     * @param updateApprovalTeamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mpa.model.UpdateApprovalTeamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApprovalTeam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check your
     *         permissions, and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist. Check the resource ID, and try again.
     *         </li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for your account. Request a quota
     *         increase or reduce your request size.</li>
     *         <li>InternalServerException The service encountered an internal error. Try your request again. If the
     *         problem persists, contact Amazon Web Services Support.</li>
     *         <li>ConflictException The request cannot be completed because it conflicts with the current state of a
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MpaException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MpaAsyncClient.UpdateApprovalTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mpa-2022-07-26/UpdateApprovalTeam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApprovalTeamResponse> updateApprovalTeam(
            Consumer<UpdateApprovalTeamRequest.Builder> updateApprovalTeamRequest) {
        return updateApprovalTeam(UpdateApprovalTeamRequest.builder().applyMutation(updateApprovalTeamRequest).build());
    }

    @Override
    default MpaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MpaAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MpaAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MpaAsyncClient}.
     */
    static MpaAsyncClientBuilder builder() {
        return new DefaultMpaAsyncClientBuilder();
    }
}
