/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SessionExecutionStatus {
    EXECUTED("EXECUTED"),
    FAILED("FAILED"),
    PENDING("PENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SessionExecutionStatus> VALUE_MAP;
    private final String value;

    private SessionExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionExecutionStatus> knownValues() {
        EnumSet<SessionExecutionStatus> knownValues = EnumSet.allOf(SessionExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SessionExecutionStatus.class, SessionExecutionStatus::toString);
    }
}

