/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIdentitySourceRequest extends MpaRequest implements
        ToCopyableBuilder<CreateIdentitySourceRequest.Builder, CreateIdentitySourceRequest> {
    private static final SdkField<IdentitySourceParameters> IDENTITY_SOURCE_PARAMETERS_FIELD = SdkField
            .<IdentitySourceParameters> builder(MarshallingType.SDK_POJO).memberName("IdentitySourceParameters")
            .getter(getter(CreateIdentitySourceRequest::identitySourceParameters))
            .setter(setter(Builder::identitySourceParameters)).constructor(IdentitySourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceParameters").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateIdentitySourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateIdentitySourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_SOURCE_PARAMETERS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IdentitySourceParameters identitySourceParameters;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateIdentitySourceRequest(BuilderImpl builder) {
        super(builder);
        this.identitySourceParameters = builder.identitySourceParameters;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A <code> IdentitySourceParameters</code> object. Contains details for the resource that provides identities to
     * the identity source. For example, an IAM Identity Center instance.
     * </p>
     * 
     * @return A <code> IdentitySourceParameters</code> object. Contains details for the resource that provides
     *         identities to the identity source. For example, an IAM Identity Center instance.
     */
    public final IdentitySourceParameters identitySourceParameters() {
        return identitySourceParameters;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the
     * Amazon Web Services populates this field.
     * </p>
     * <note>
     * <p>
     * <b>What is idempotency?</b>
     * </p>
     * <p>
     * When you make a mutating API request, the request typically returns a result before the operation's asynchronous
     * workflows have completed. Operations might also time out or encounter other server issues before they complete,
     * even though the request has already returned a result. This could make it difficult to determine whether the
     * request succeeded or not, and could lead to multiple retries to ensure that the operation completes successfully.
     * However, if the original request and the subsequent retries are successful, the operation is completed multiple
     * times. This means that you might create more resources than you intended.
     * </p>
     * <p>
     * <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request, if
     * the original request completes successfully, any subsequent retries complete successfully without performing any
     * further actions.
     * </p>
     * </note>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services populates this field.</p> <note>
     *         <p>
     *         <b>What is idempotency?</b>
     *         </p>
     *         <p>
     *         When you make a mutating API request, the request typically returns a result before the operation's
     *         asynchronous workflows have completed. Operations might also time out or encounter other server issues
     *         before they complete, even though the request has already returned a result. This could make it difficult
     *         to determine whether the request succeeded or not, and could lead to multiple retries to ensure that the
     *         operation completes successfully. However, if the original request and the subsequent retries are
     *         successful, the operation is completed multiple times. This means that you might create more resources
     *         than you intended.
     *         </p>
     *         <p>
     *         <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent
     *         request, if the original request completes successfully, any subsequent retries complete successfully
     *         without performing any further actions.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tag you want to attach to the identity source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tag you want to attach to the identity source.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentitySourceRequest)) {
            return false;
        }
        CreateIdentitySourceRequest other = (CreateIdentitySourceRequest) obj;
        return Objects.equals(identitySourceParameters(), other.identitySourceParameters())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIdentitySourceRequest").add("IdentitySourceParameters", identitySourceParameters())
                .add("ClientToken", clientToken()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentitySourceParameters":
            return Optional.ofNullable(clazz.cast(identitySourceParameters()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentitySourceParameters", IDENTITY_SOURCE_PARAMETERS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentitySourceRequest, T> g) {
        return obj -> g.apply((CreateIdentitySourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIdentitySourceRequest> {
        /**
         * <p>
         * A <code> IdentitySourceParameters</code> object. Contains details for the resource that provides identities
         * to the identity source. For example, an IAM Identity Center instance.
         * </p>
         * 
         * @param identitySourceParameters
         *        A <code> IdentitySourceParameters</code> object. Contains details for the resource that provides
         *        identities to the identity source. For example, an IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceParameters(IdentitySourceParameters identitySourceParameters);

        /**
         * <p>
         * A <code> IdentitySourceParameters</code> object. Contains details for the resource that provides identities
         * to the identity source. For example, an IAM Identity Center instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentitySourceParameters.Builder}
         * avoiding the need to create one manually via {@link IdentitySourceParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentitySourceParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #identitySourceParameters(IdentitySourceParameters)}.
         * 
         * @param identitySourceParameters
         *        a consumer that will call methods on {@link IdentitySourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identitySourceParameters(IdentitySourceParameters)
         */
        default Builder identitySourceParameters(Consumer<IdentitySourceParameters.Builder> identitySourceParameters) {
            return identitySourceParameters(IdentitySourceParameters.builder().applyMutation(identitySourceParameters).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
         * the Amazon Web Services populates this field.
         * </p>
         * <note>
         * <p>
         * <b>What is idempotency?</b>
         * </p>
         * <p>
         * When you make a mutating API request, the request typically returns a result before the operation's
         * asynchronous workflows have completed. Operations might also time out or encounter other server issues before
         * they complete, even though the request has already returned a result. This could make it difficult to
         * determine whether the request succeeded or not, and could lead to multiple retries to ensure that the
         * operation completes successfully. However, if the original request and the subsequent retries are successful,
         * the operation is completed multiple times. This means that you might create more resources than you intended.
         * </p>
         * <p>
         * <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request,
         * if the original request completes successfully, any subsequent retries complete successfully without
         * performing any further actions.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services populates this field.</p> <note>
         *        <p>
         *        <b>What is idempotency?</b>
         *        </p>
         *        <p>
         *        When you make a mutating API request, the request typically returns a result before the operation's
         *        asynchronous workflows have completed. Operations might also time out or encounter other server issues
         *        before they complete, even though the request has already returned a result. This could make it
         *        difficult to determine whether the request succeeded or not, and could lead to multiple retries to
         *        ensure that the operation completes successfully. However, if the original request and the subsequent
         *        retries are successful, the operation is completed multiple times. This means that you might create
         *        more resources than you intended.
         *        </p>
         *        <p>
         *        <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent
         *        request, if the original request completes successfully, any subsequent retries complete successfully
         *        without performing any further actions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Tag you want to attach to the identity source.
         * </p>
         * 
         * @param tags
         *        Tag you want to attach to the identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MpaRequest.BuilderImpl implements Builder {
        private IdentitySourceParameters identitySourceParameters;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentitySourceRequest model) {
            super(model);
            identitySourceParameters(model.identitySourceParameters);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final IdentitySourceParameters.Builder getIdentitySourceParameters() {
            return identitySourceParameters != null ? identitySourceParameters.toBuilder() : null;
        }

        public final void setIdentitySourceParameters(IdentitySourceParameters.BuilderImpl identitySourceParameters) {
            this.identitySourceParameters = identitySourceParameters != null ? identitySourceParameters.build() : null;
        }

        @Override
        public final Builder identitySourceParameters(IdentitySourceParameters identitySourceParameters) {
            this.identitySourceParameters = identitySourceParameters;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdentitySourceRequest build() {
            return new CreateIdentitySourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
