/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApprovalTeamRequest extends MpaRequest implements
        ToCopyableBuilder<CreateApprovalTeamRequest.Builder, CreateApprovalTeamRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateApprovalTeamRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ApprovalStrategy> APPROVAL_STRATEGY_FIELD = SdkField
            .<ApprovalStrategy> builder(MarshallingType.SDK_POJO).memberName("ApprovalStrategy")
            .getter(getter(CreateApprovalTeamRequest::approvalStrategy)).setter(setter(Builder::approvalStrategy))
            .constructor(ApprovalStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()).build();

    private static final SdkField<List<ApprovalTeamRequestApprover>> APPROVERS_FIELD = SdkField
            .<List<ApprovalTeamRequestApprover>> builder(MarshallingType.LIST)
            .memberName("Approvers")
            .getter(getter(CreateApprovalTeamRequest::approvers))
            .setter(setter(Builder::approvers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Approvers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApprovalTeamRequestApprover> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApprovalTeamRequestApprover::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateApprovalTeamRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<PolicyReference>> POLICIES_FIELD = SdkField
            .<List<PolicyReference>> builder(MarshallingType.LIST)
            .memberName("Policies")
            .getter(getter(CreateApprovalTeamRequest::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateApprovalTeamRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateApprovalTeamRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            APPROVAL_STRATEGY_FIELD, APPROVERS_FIELD, DESCRIPTION_FIELD, POLICIES_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final ApprovalStrategy approvalStrategy;

    private final List<ApprovalTeamRequestApprover> approvers;

    private final String description;

    private final List<PolicyReference> policies;

    private final String name;

    private final Map<String, String> tags;

    private CreateApprovalTeamRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.approvalStrategy = builder.approvalStrategy;
        this.approvers = builder.approvers;
        this.description = builder.description;
        this.policies = builder.policies;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the
     * Amazon Web Services populates this field.
     * </p>
     * <note>
     * <p>
     * <b>What is idempotency?</b>
     * </p>
     * <p>
     * When you make a mutating API request, the request typically returns a result before the operation's asynchronous
     * workflows have completed. Operations might also time out or encounter other server issues before they complete,
     * even though the request has already returned a result. This could make it difficult to determine whether the
     * request succeeded or not, and could lead to multiple retries to ensure that the operation completes successfully.
     * However, if the original request and the subsequent retries are successful, the operation is completed multiple
     * times. This means that you might create more resources than you intended.
     * </p>
     * <p>
     * <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request, if
     * the original request completes successfully, any subsequent retries complete successfully without performing any
     * further actions.
     * </p>
     * </note>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services populates this field.</p> <note>
     *         <p>
     *         <b>What is idempotency?</b>
     *         </p>
     *         <p>
     *         When you make a mutating API request, the request typically returns a result before the operation's
     *         asynchronous workflows have completed. Operations might also time out or encounter other server issues
     *         before they complete, even though the request has already returned a result. This could make it difficult
     *         to determine whether the request succeeded or not, and could lead to multiple retries to ensure that the
     *         operation completes successfully. However, if the original request and the subsequent retries are
     *         successful, the operation is completed multiple times. This means that you might create more resources
     *         than you intended.
     *         </p>
     *         <p>
     *         <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent
     *         request, if the original request completes successfully, any subsequent retries complete successfully
     *         without performing any further actions.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
     * </p>
     * 
     * @return An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
     */
    public final ApprovalStrategy approvalStrategy() {
        return approvalStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Approvers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasApprovers() {
        return approvers != null && !(approvers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ApprovalTeamRequesterApprovers</code> objects. Contains details for the approvers in the team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApprovers} method.
     * </p>
     * 
     * @return An array of <code>ApprovalTeamRequesterApprovers</code> objects. Contains details for the approvers in
     *         the team.
     */
    public final List<ApprovalTeamRequestApprover> approvers() {
        return approvers;
    }

    /**
     * <p>
     * Description for the team.
     * </p>
     * 
     * @return Description for the team.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
     * team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions
     *         for team resources.</p>
     *         <p>
     *         The protected operation for a service integration might require specific permissions. For more
     *         information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
     *         other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     */
    public final List<PolicyReference> policies() {
        return policies;
    }

    /**
     * <p>
     * Name of the team.
     * </p>
     * 
     * @return Name of the team.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags you want to attach to the team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags you want to attach to the team.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovers() ? approvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApprovalTeamRequest)) {
            return false;
        }
        CreateApprovalTeamRequest other = (CreateApprovalTeamRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(approvalStrategy(), other.approvalStrategy())
                && hasApprovers() == other.hasApprovers() && Objects.equals(approvers(), other.approvers())
                && Objects.equals(description(), other.description()) && hasPolicies() == other.hasPolicies()
                && Objects.equals(policies(), other.policies()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApprovalTeamRequest").add("ClientToken", clientToken())
                .add("ApprovalStrategy", approvalStrategy()).add("Approvers", hasApprovers() ? approvers() : null)
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Policies", hasPolicies() ? policies() : null).add("Name", name())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ApprovalStrategy":
            return Optional.ofNullable(clazz.cast(approvalStrategy()));
        case "Approvers":
            return Optional.ofNullable(clazz.cast(approvers()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("Approvers", APPROVERS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApprovalTeamRequest, T> g) {
        return obj -> g.apply((CreateApprovalTeamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApprovalTeamRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
         * the Amazon Web Services populates this field.
         * </p>
         * <note>
         * <p>
         * <b>What is idempotency?</b>
         * </p>
         * <p>
         * When you make a mutating API request, the request typically returns a result before the operation's
         * asynchronous workflows have completed. Operations might also time out or encounter other server issues before
         * they complete, even though the request has already returned a result. This could make it difficult to
         * determine whether the request succeeded or not, and could lead to multiple retries to ensure that the
         * operation completes successfully. However, if the original request and the subsequent retries are successful,
         * the operation is completed multiple times. This means that you might create more resources than you intended.
         * </p>
         * <p>
         * <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request,
         * if the original request completes successfully, any subsequent retries complete successfully without
         * performing any further actions.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services populates this field.</p> <note>
         *        <p>
         *        <b>What is idempotency?</b>
         *        </p>
         *        <p>
         *        When you make a mutating API request, the request typically returns a result before the operation's
         *        asynchronous workflows have completed. Operations might also time out or encounter other server issues
         *        before they complete, even though the request has already returned a result. This could make it
         *        difficult to determine whether the request succeeded or not, and could lead to multiple retries to
         *        ensure that the operation completes successfully. However, if the original request and the subsequent
         *        retries are successful, the operation is completed multiple times. This means that you might create
         *        more resources than you intended.
         *        </p>
         *        <p>
         *        <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent
         *        request, if the original request completes successfully, any subsequent retries complete successfully
         *        without performing any further actions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
         * </p>
         * 
         * @param approvalStrategy
         *        An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalStrategy(ApprovalStrategy approvalStrategy);

        /**
         * <p>
         * An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApprovalStrategy.Builder} avoiding the
         * need to create one manually via {@link ApprovalStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #approvalStrategy(ApprovalStrategy)}.
         * 
         * @param approvalStrategy
         *        a consumer that will call methods on {@link ApprovalStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalStrategy(ApprovalStrategy)
         */
        default Builder approvalStrategy(Consumer<ApprovalStrategy.Builder> approvalStrategy) {
            return approvalStrategy(ApprovalStrategy.builder().applyMutation(approvalStrategy).build());
        }

        /**
         * <p>
         * An array of <code>ApprovalTeamRequesterApprovers</code> objects. Contains details for the approvers in the
         * team.
         * </p>
         * 
         * @param approvers
         *        An array of <code>ApprovalTeamRequesterApprovers</code> objects. Contains details for the approvers in
         *        the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvers(Collection<ApprovalTeamRequestApprover> approvers);

        /**
         * <p>
         * An array of <code>ApprovalTeamRequesterApprovers</code> objects. Contains details for the approvers in the
         * team.
         * </p>
         * 
         * @param approvers
         *        An array of <code>ApprovalTeamRequesterApprovers</code> objects. Contains details for the approvers in
         *        the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvers(ApprovalTeamRequestApprover... approvers);

        /**
         * <p>
         * An array of <code>ApprovalTeamRequesterApprovers</code> objects. Contains details for the approvers in the
         * team.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover.Builder#build()} is called
         * immediately and its result is passed to {@link #approvers(List<ApprovalTeamRequestApprover>)}.
         * 
         * @param approvers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvers(java.util.Collection<ApprovalTeamRequestApprover>)
         */
        Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder>... approvers);

        /**
         * <p>
         * Description for the team.
         * </p>
         * 
         * @param description
         *        Description for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
         * team resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * 
         * @param policies
         *        An array of <code>PolicyReference</code> objects. Contains a list of policies that define the
         *        permissions for team resources.</p>
         *        <p>
         *        The protected operation for a service integration might require specific permissions. For more
         *        information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
         *        other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<PolicyReference> policies);

        /**
         * <p>
         * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
         * team resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * 
         * @param policies
         *        An array of <code>PolicyReference</code> objects. Contains a list of policies that define the
         *        permissions for team resources.</p>
         *        <p>
         *        The protected operation for a service integration might require specific permissions. For more
         *        information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
         *        other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(PolicyReference... policies);

        /**
         * <p>
         * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
         * team resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mpa.model.PolicyReference.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mpa.model.PolicyReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mpa.model.PolicyReference.Builder#build()} is called immediately and
         * its result is passed to {@link #policies(List<PolicyReference>)}.
         * 
         * @param policies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mpa.model.PolicyReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(java.util.Collection<PolicyReference>)
         */
        Builder policies(Consumer<PolicyReference.Builder>... policies);

        /**
         * <p>
         * Name of the team.
         * </p>
         * 
         * @param name
         *        Name of the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Tags you want to attach to the team.
         * </p>
         * 
         * @param tags
         *        Tags you want to attach to the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MpaRequest.BuilderImpl implements Builder {
        private String clientToken;

        private ApprovalStrategy approvalStrategy;

        private List<ApprovalTeamRequestApprover> approvers = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<PolicyReference> policies = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApprovalTeamRequest model) {
            super(model);
            clientToken(model.clientToken);
            approvalStrategy(model.approvalStrategy);
            approvers(model.approvers);
            description(model.description);
            policies(model.policies);
            name(model.name);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ApprovalStrategy.Builder getApprovalStrategy() {
            return approvalStrategy != null ? approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategy.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategy approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final List<ApprovalTeamRequestApprover.Builder> getApprovers() {
            List<ApprovalTeamRequestApprover.Builder> result = ApprovalTeamRequestApproversCopier.copyToBuilder(this.approvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovers(Collection<ApprovalTeamRequestApprover.BuilderImpl> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copyFromBuilder(approvers);
        }

        @Override
        public final Builder approvers(Collection<ApprovalTeamRequestApprover> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copy(approvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(ApprovalTeamRequestApprover... approvers) {
            approvers(Arrays.asList(approvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder>... approvers) {
            approvers(Stream.of(approvers).map(c -> ApprovalTeamRequestApprover.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<PolicyReference.Builder> getPolicies() {
            List<PolicyReference.Builder> result = PoliciesReferencesCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<PolicyReference.BuilderImpl> policies) {
            this.policies = PoliciesReferencesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<PolicyReference> policies) {
            this.policies = PoliciesReferencesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyReference... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<PolicyReference.Builder>... policies) {
            policies(Stream.of(policies).map(c -> PolicyReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApprovalTeamRequest build() {
            return new CreateApprovalTeamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
