/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerDetail;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServersResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, ListServersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServersResponse.getter(ListServersResponse::nextToken)).setter(ListServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ServerDetail>> SERVER_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverInfos").getter(ListServersResponse.getter(ListServersResponse::serverInfos)).setter(ListServersResponse.setter(Builder::serverInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVER_INFOS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ServerDetail> serverInfos;

    private ListServersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverInfos = builder.serverInfos;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServerInfos() {
        return this.serverInfos != null && !(this.serverInfos instanceof SdkAutoConstructList);
    }

    public final List<ServerDetail> serverInfos() {
        return this.serverInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerInfos() ? this.serverInfos() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServersResponse)) {
            return false;
        }
        ListServersResponse other = (ListServersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServerInfos() == other.hasServerInfos() && Objects.equals(this.serverInfos(), other.serverInfos());
    }

    public final String toString() {
        return ToString.builder((String)"ListServersResponse").add("NextToken", (Object)this.nextToken()).add("ServerInfos", this.hasServerInfos() ? this.serverInfos() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "serverInfos": {
                return Optional.ofNullable(clazz.cast(this.serverInfos()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("serverInfos", SERVER_INFOS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServersResponse, T> g) {
        return obj -> g.apply((ListServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServerDetail> serverInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serverInfos(model.serverInfos);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServerDetail.Builder> getServerInfos() {
            List<ServerDetail.Builder> result = ServerDetailsCopier.copyToBuilder(this.serverInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerInfos(Collection<ServerDetail.BuilderImpl> serverInfos) {
            this.serverInfos = ServerDetailsCopier.copyFromBuilder(serverInfos);
        }

        @Override
        public final Builder serverInfos(Collection<ServerDetail> serverInfos) {
            this.serverInfos = ServerDetailsCopier.copy(serverInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverInfos(ServerDetail ... serverInfos) {
            this.serverInfos(Arrays.asList(serverInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverInfos(Consumer<ServerDetail.Builder> ... serverInfos) {
            this.serverInfos(Stream.of(serverInfos).map(c -> (ServerDetail)((ServerDetail.Builder)ServerDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServersResponse build() {
            return new ListServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServersResponse> {
        public Builder nextToken(String var1);

        public Builder serverInfos(Collection<ServerDetail> var1);

        public Builder serverInfos(ServerDetail ... var1);

        public Builder serverInfos(Consumer<ServerDetail.Builder> ... var1);
    }
}

