/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.Strategy;
import software.amazon.awssdk.services.migrationhubstrategy.model.TargetDestination;
import software.amazon.awssdk.services.migrationhubstrategy.model.TransformationToolName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StrategyOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StrategyOption> {
    private static final SdkField<Boolean> IS_PREFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPreferred").getter(StrategyOption.getter(StrategyOption::isPreferred)).setter(StrategyOption.setter(Builder::isPreferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPreferred").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategy").getter(StrategyOption.getter(StrategyOption::strategyAsString)).setter(StrategyOption.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()}).build();
    private static final SdkField<String> TARGET_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetDestination").getter(StrategyOption.getter(StrategyOption::targetDestinationAsString)).setter(StrategyOption.setter(Builder::targetDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDestination").build()}).build();
    private static final SdkField<String> TOOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toolName").getter(StrategyOption.getter(StrategyOption::toolNameAsString)).setter(StrategyOption.setter(Builder::toolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PREFERRED_FIELD, STRATEGY_FIELD, TARGET_DESTINATION_FIELD, TOOL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StrategyOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isPreferred;
    private final String strategy;
    private final String targetDestination;
    private final String toolName;

    private StrategyOption(BuilderImpl builder) {
        this.isPreferred = builder.isPreferred;
        this.strategy = builder.strategy;
        this.targetDestination = builder.targetDestination;
        this.toolName = builder.toolName;
    }

    public final Boolean isPreferred() {
        return this.isPreferred;
    }

    public final Strategy strategy() {
        return Strategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public final TargetDestination targetDestination() {
        return TargetDestination.fromValue(this.targetDestination);
    }

    public final String targetDestinationAsString() {
        return this.targetDestination;
    }

    public final TransformationToolName toolName() {
        return TransformationToolName.fromValue(this.toolName);
    }

    public final String toolNameAsString() {
        return this.toolName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isPreferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDestinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrategyOption)) {
            return false;
        }
        StrategyOption other = (StrategyOption)obj;
        return Objects.equals(this.isPreferred(), other.isPreferred()) && Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.targetDestinationAsString(), other.targetDestinationAsString()) && Objects.equals(this.toolNameAsString(), other.toolNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StrategyOption").add("IsPreferred", (Object)this.isPreferred()).add("Strategy", (Object)this.strategyAsString()).add("TargetDestination", (Object)this.targetDestinationAsString()).add("ToolName", (Object)this.toolNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isPreferred": {
                return Optional.ofNullable(clazz.cast(this.isPreferred()));
            }
            case "strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "targetDestination": {
                return Optional.ofNullable(clazz.cast(this.targetDestinationAsString()));
            }
            case "toolName": {
                return Optional.ofNullable(clazz.cast(this.toolNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isPreferred", IS_PREFERRED_FIELD);
        map.put("strategy", STRATEGY_FIELD);
        map.put("targetDestination", TARGET_DESTINATION_FIELD);
        map.put("toolName", TOOL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StrategyOption, T> g) {
        return obj -> g.apply((StrategyOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isPreferred;
        private String strategy;
        private String targetDestination;
        private String toolName;

        private BuilderImpl() {
        }

        private BuilderImpl(StrategyOption model) {
            this.isPreferred(model.isPreferred);
            this.strategy(model.strategy);
            this.targetDestination(model.targetDestination);
            this.toolName(model.toolName);
        }

        public final Boolean getIsPreferred() {
            return this.isPreferred;
        }

        public final void setIsPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
        }

        @Override
        public final Builder isPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
            return this;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(Strategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final String getTargetDestination() {
            return this.targetDestination;
        }

        public final void setTargetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
        }

        @Override
        public final Builder targetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
            return this;
        }

        @Override
        public final Builder targetDestination(TargetDestination targetDestination) {
            this.targetDestination(targetDestination == null ? null : targetDestination.toString());
            return this;
        }

        public final String getToolName() {
            return this.toolName;
        }

        public final void setToolName(String toolName) {
            this.toolName = toolName;
        }

        @Override
        public final Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        @Override
        public final Builder toolName(TransformationToolName toolName) {
            this.toolName(toolName == null ? null : toolName.toString());
            return this;
        }

        public StrategyOption build() {
            return new StrategyOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StrategyOption> {
        public Builder isPreferred(Boolean var1);

        public Builder strategy(String var1);

        public Builder strategy(Strategy var1);

        public Builder targetDestination(String var1);

        public Builder targetDestination(TargetDestination var1);

        public Builder toolName(String var1);

        public Builder toolName(TransformationToolName var1);
    }
}

