/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CollectorHealth {
    COLLECTOR_HEALTHY("COLLECTOR_HEALTHY"),
    COLLECTOR_UNHEALTHY("COLLECTOR_UNHEALTHY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CollectorHealth> VALUE_MAP;
    private final String value;

    private CollectorHealth(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CollectorHealth fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CollectorHealth> knownValues() {
        EnumSet<CollectorHealth> knownValues = EnumSet.allOf(CollectorHealth.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CollectorHealth.class, CollectorHealth::toString);
    }
}

