/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.ImportFileTaskStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImportFileTaskResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, GetImportFileTaskResponse> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::completionTime)).setter(GetImportFileTaskResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::id)).setter(GetImportFileTaskResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> IMPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importName").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::importName)).setter(GetImportFileTaskResponse.setter(Builder::importName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importName").build()}).build();
    private static final SdkField<String> INPUT_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputS3Bucket").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::inputS3Bucket)).setter(GetImportFileTaskResponse.setter(Builder::inputS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputS3Bucket").build()}).build();
    private static final SdkField<String> INPUT_S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputS3Key").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::inputS3Key)).setter(GetImportFileTaskResponse.setter(Builder::inputS3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputS3Key").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RECORDS_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRecordsFailed").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::numberOfRecordsFailed)).setter(GetImportFileTaskResponse.setter(Builder::numberOfRecordsFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsFailed").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RECORDS_SUCCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRecordsSuccess").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::numberOfRecordsSuccess)).setter(GetImportFileTaskResponse.setter(Builder::numberOfRecordsSuccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsSuccess").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::startTime)).setter(GetImportFileTaskResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::statusAsString)).setter(GetImportFileTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REPORT_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReportS3Bucket").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::statusReportS3Bucket)).setter(GetImportFileTaskResponse.setter(Builder::statusReportS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReportS3Bucket").build()}).build();
    private static final SdkField<String> STATUS_REPORT_S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReportS3Key").getter(GetImportFileTaskResponse.getter(GetImportFileTaskResponse::statusReportS3Key)).setter(GetImportFileTaskResponse.setter(Builder::statusReportS3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReportS3Key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, ID_FIELD, IMPORT_NAME_FIELD, INPUT_S3_BUCKET_FIELD, INPUT_S3_KEY_FIELD, NUMBER_OF_RECORDS_FAILED_FIELD, NUMBER_OF_RECORDS_SUCCESS_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_REPORT_S3_BUCKET_FIELD, STATUS_REPORT_S3_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetImportFileTaskResponse.memberNameToFieldInitializer();
    private final Instant completionTime;
    private final String id;
    private final String importName;
    private final String inputS3Bucket;
    private final String inputS3Key;
    private final Integer numberOfRecordsFailed;
    private final Integer numberOfRecordsSuccess;
    private final Instant startTime;
    private final String status;
    private final String statusReportS3Bucket;
    private final String statusReportS3Key;

    private GetImportFileTaskResponse(BuilderImpl builder) {
        super(builder);
        this.completionTime = builder.completionTime;
        this.id = builder.id;
        this.importName = builder.importName;
        this.inputS3Bucket = builder.inputS3Bucket;
        this.inputS3Key = builder.inputS3Key;
        this.numberOfRecordsFailed = builder.numberOfRecordsFailed;
        this.numberOfRecordsSuccess = builder.numberOfRecordsSuccess;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusReportS3Bucket = builder.statusReportS3Bucket;
        this.statusReportS3Key = builder.statusReportS3Key;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String id() {
        return this.id;
    }

    public final String importName() {
        return this.importName;
    }

    public final String inputS3Bucket() {
        return this.inputS3Bucket;
    }

    public final String inputS3Key() {
        return this.inputS3Key;
    }

    public final Integer numberOfRecordsFailed() {
        return this.numberOfRecordsFailed;
    }

    public final Integer numberOfRecordsSuccess() {
        return this.numberOfRecordsSuccess;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final ImportFileTaskStatus status() {
        return ImportFileTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReportS3Bucket() {
        return this.statusReportS3Bucket;
    }

    public final String statusReportS3Key() {
        return this.statusReportS3Key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.importName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecordsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecordsSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReportS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReportS3Key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImportFileTaskResponse)) {
            return false;
        }
        GetImportFileTaskResponse other = (GetImportFileTaskResponse)((Object)obj);
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.importName(), other.importName()) && Objects.equals(this.inputS3Bucket(), other.inputS3Bucket()) && Objects.equals(this.inputS3Key(), other.inputS3Key()) && Objects.equals(this.numberOfRecordsFailed(), other.numberOfRecordsFailed()) && Objects.equals(this.numberOfRecordsSuccess(), other.numberOfRecordsSuccess()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReportS3Bucket(), other.statusReportS3Bucket()) && Objects.equals(this.statusReportS3Key(), other.statusReportS3Key());
    }

    public final String toString() {
        return ToString.builder((String)"GetImportFileTaskResponse").add("CompletionTime", (Object)this.completionTime()).add("Id", (Object)this.id()).add("ImportName", (Object)this.importName()).add("InputS3Bucket", (Object)this.inputS3Bucket()).add("InputS3Key", (Object)this.inputS3Key()).add("NumberOfRecordsFailed", (Object)this.numberOfRecordsFailed()).add("NumberOfRecordsSuccess", (Object)this.numberOfRecordsSuccess()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("StatusReportS3Bucket", (Object)this.statusReportS3Bucket()).add("StatusReportS3Key", (Object)this.statusReportS3Key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "importName": {
                return Optional.ofNullable(clazz.cast(this.importName()));
            }
            case "inputS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.inputS3Bucket()));
            }
            case "inputS3Key": {
                return Optional.ofNullable(clazz.cast(this.inputS3Key()));
            }
            case "numberOfRecordsFailed": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecordsFailed()));
            }
            case "numberOfRecordsSuccess": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecordsSuccess()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReportS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.statusReportS3Bucket()));
            }
            case "statusReportS3Key": {
                return Optional.ofNullable(clazz.cast(this.statusReportS3Key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("completionTime", COMPLETION_TIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("importName", IMPORT_NAME_FIELD);
        map.put("inputS3Bucket", INPUT_S3_BUCKET_FIELD);
        map.put("inputS3Key", INPUT_S3_KEY_FIELD);
        map.put("numberOfRecordsFailed", NUMBER_OF_RECORDS_FAILED_FIELD);
        map.put("numberOfRecordsSuccess", NUMBER_OF_RECORDS_SUCCESS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReportS3Bucket", STATUS_REPORT_S3_BUCKET_FIELD);
        map.put("statusReportS3Key", STATUS_REPORT_S3_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImportFileTaskResponse, T> g) {
        return obj -> g.apply((GetImportFileTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private Instant completionTime;
        private String id;
        private String importName;
        private String inputS3Bucket;
        private String inputS3Key;
        private Integer numberOfRecordsFailed;
        private Integer numberOfRecordsSuccess;
        private Instant startTime;
        private String status;
        private String statusReportS3Bucket;
        private String statusReportS3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImportFileTaskResponse model) {
            super(model);
            this.completionTime(model.completionTime);
            this.id(model.id);
            this.importName(model.importName);
            this.inputS3Bucket(model.inputS3Bucket);
            this.inputS3Key(model.inputS3Key);
            this.numberOfRecordsFailed(model.numberOfRecordsFailed);
            this.numberOfRecordsSuccess(model.numberOfRecordsSuccess);
            this.startTime(model.startTime);
            this.status(model.status);
            this.statusReportS3Bucket(model.statusReportS3Bucket);
            this.statusReportS3Key(model.statusReportS3Key);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getImportName() {
            return this.importName;
        }

        public final void setImportName(String importName) {
            this.importName = importName;
        }

        @Override
        public final Builder importName(String importName) {
            this.importName = importName;
            return this;
        }

        public final String getInputS3Bucket() {
            return this.inputS3Bucket;
        }

        public final void setInputS3Bucket(String inputS3Bucket) {
            this.inputS3Bucket = inputS3Bucket;
        }

        @Override
        public final Builder inputS3Bucket(String inputS3Bucket) {
            this.inputS3Bucket = inputS3Bucket;
            return this;
        }

        public final String getInputS3Key() {
            return this.inputS3Key;
        }

        public final void setInputS3Key(String inputS3Key) {
            this.inputS3Key = inputS3Key;
        }

        @Override
        public final Builder inputS3Key(String inputS3Key) {
            this.inputS3Key = inputS3Key;
            return this;
        }

        public final Integer getNumberOfRecordsFailed() {
            return this.numberOfRecordsFailed;
        }

        public final void setNumberOfRecordsFailed(Integer numberOfRecordsFailed) {
            this.numberOfRecordsFailed = numberOfRecordsFailed;
        }

        @Override
        public final Builder numberOfRecordsFailed(Integer numberOfRecordsFailed) {
            this.numberOfRecordsFailed = numberOfRecordsFailed;
            return this;
        }

        public final Integer getNumberOfRecordsSuccess() {
            return this.numberOfRecordsSuccess;
        }

        public final void setNumberOfRecordsSuccess(Integer numberOfRecordsSuccess) {
            this.numberOfRecordsSuccess = numberOfRecordsSuccess;
        }

        @Override
        public final Builder numberOfRecordsSuccess(Integer numberOfRecordsSuccess) {
            this.numberOfRecordsSuccess = numberOfRecordsSuccess;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportFileTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReportS3Bucket() {
            return this.statusReportS3Bucket;
        }

        public final void setStatusReportS3Bucket(String statusReportS3Bucket) {
            this.statusReportS3Bucket = statusReportS3Bucket;
        }

        @Override
        public final Builder statusReportS3Bucket(String statusReportS3Bucket) {
            this.statusReportS3Bucket = statusReportS3Bucket;
            return this;
        }

        public final String getStatusReportS3Key() {
            return this.statusReportS3Key;
        }

        public final void setStatusReportS3Key(String statusReportS3Key) {
            this.statusReportS3Key = statusReportS3Key;
        }

        @Override
        public final Builder statusReportS3Key(String statusReportS3Key) {
            this.statusReportS3Key = statusReportS3Key;
            return this;
        }

        @Override
        public GetImportFileTaskResponse build() {
            return new GetImportFileTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImportFileTaskResponse> {
        public Builder completionTime(Instant var1);

        public Builder id(String var1);

        public Builder importName(String var1);

        public Builder inputS3Bucket(String var1);

        public Builder inputS3Key(String var1);

        public Builder numberOfRecordsFailed(Integer var1);

        public Builder numberOfRecordsSuccess(Integer var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ImportFileTaskStatus var1);

        public Builder statusReportS3Bucket(String var1);

        public Builder statusReportS3Key(String var1);
    }
}

