/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyAsyncClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse;

public class ListAnalyzableServersPublisher
implements SdkPublisher<ListAnalyzableServersResponse> {
    private final MigrationHubStrategyAsyncClient client;
    private final ListAnalyzableServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnalyzableServersPublisher(MigrationHubStrategyAsyncClient client, ListAnalyzableServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnalyzableServersPublisher(MigrationHubStrategyAsyncClient client, ListAnalyzableServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnalyzableServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnalyzableServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalyzableServerSummary> analyzableServers() {
        Function<ListAnalyzableServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.analyzableServers() != null) {
                return response.analyzableServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnalyzableServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnalyzableServersResponseFetcher
    implements AsyncPageFetcher<ListAnalyzableServersResponse> {
        private ListAnalyzableServersResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalyzableServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnalyzableServersResponse> nextPage(ListAnalyzableServersResponse previousPage) {
            if (previousPage == null) {
                return ListAnalyzableServersPublisher.this.client.listAnalyzableServers(ListAnalyzableServersPublisher.this.firstRequest);
            }
            return ListAnalyzableServersPublisher.this.client.listAnalyzableServers((ListAnalyzableServersRequest)((Object)ListAnalyzableServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

