/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RunTimeAnalyzerName {
    A2_C_ANALYZER("A2C_ANALYZER"),
    REHOST_ANALYZER("REHOST_ANALYZER"),
    EMP_PA_ANALYZER("EMP_PA_ANALYZER"),
    DATABASE_ANALYZER("DATABASE_ANALYZER"),
    SCT_ANALYZER("SCT_ANALYZER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RunTimeAnalyzerName> VALUE_MAP;
    private final String value;

    private RunTimeAnalyzerName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RunTimeAnalyzerName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RunTimeAnalyzerName> knownValues() {
        EnumSet<RunTimeAnalyzerName> knownValues = EnumSet.allOf(RunTimeAnalyzerName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RunTimeAnalyzerName.class, RunTimeAnalyzerName::toString);
    }
}

