/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationMode;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationPreferences;
import software.amazon.awssdk.services.migrationhubstrategy.model.DatabasePreferences;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.PrioritizeBusinessGoals;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPortfolioPreferencesRequest
extends MigrationHubStrategyRequest
implements ToCopyableBuilder<Builder, PutPortfolioPreferencesRequest> {
    private static final SdkField<String> APPLICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationMode").getter(PutPortfolioPreferencesRequest.getter(PutPortfolioPreferencesRequest::applicationModeAsString)).setter(PutPortfolioPreferencesRequest.setter(Builder::applicationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationMode").build()}).build();
    private static final SdkField<ApplicationPreferences> APPLICATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("applicationPreferences").getter(PutPortfolioPreferencesRequest.getter(PutPortfolioPreferencesRequest::applicationPreferences)).setter(PutPortfolioPreferencesRequest.setter(Builder::applicationPreferences)).constructor(ApplicationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationPreferences").build()}).build();
    private static final SdkField<DatabasePreferences> DATABASE_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("databasePreferences").getter(PutPortfolioPreferencesRequest.getter(PutPortfolioPreferencesRequest::databasePreferences)).setter(PutPortfolioPreferencesRequest.setter(Builder::databasePreferences)).constructor(DatabasePreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databasePreferences").build()}).build();
    private static final SdkField<PrioritizeBusinessGoals> PRIORITIZE_BUSINESS_GOALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("prioritizeBusinessGoals").getter(PutPortfolioPreferencesRequest.getter(PutPortfolioPreferencesRequest::prioritizeBusinessGoals)).setter(PutPortfolioPreferencesRequest.setter(Builder::prioritizeBusinessGoals)).constructor(PrioritizeBusinessGoals::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prioritizeBusinessGoals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_MODE_FIELD, APPLICATION_PREFERENCES_FIELD, DATABASE_PREFERENCES_FIELD, PRIORITIZE_BUSINESS_GOALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutPortfolioPreferencesRequest.memberNameToFieldInitializer();
    private final String applicationMode;
    private final ApplicationPreferences applicationPreferences;
    private final DatabasePreferences databasePreferences;
    private final PrioritizeBusinessGoals prioritizeBusinessGoals;

    private PutPortfolioPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationMode = builder.applicationMode;
        this.applicationPreferences = builder.applicationPreferences;
        this.databasePreferences = builder.databasePreferences;
        this.prioritizeBusinessGoals = builder.prioritizeBusinessGoals;
    }

    public final ApplicationMode applicationMode() {
        return ApplicationMode.fromValue(this.applicationMode);
    }

    public final String applicationModeAsString() {
        return this.applicationMode;
    }

    public final ApplicationPreferences applicationPreferences() {
        return this.applicationPreferences;
    }

    public final DatabasePreferences databasePreferences() {
        return this.databasePreferences;
    }

    public final PrioritizeBusinessGoals prioritizeBusinessGoals() {
        return this.prioritizeBusinessGoals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.databasePreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.prioritizeBusinessGoals());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPortfolioPreferencesRequest)) {
            return false;
        }
        PutPortfolioPreferencesRequest other = (PutPortfolioPreferencesRequest)((Object)obj);
        return Objects.equals(this.applicationModeAsString(), other.applicationModeAsString()) && Objects.equals(this.applicationPreferences(), other.applicationPreferences()) && Objects.equals(this.databasePreferences(), other.databasePreferences()) && Objects.equals(this.prioritizeBusinessGoals(), other.prioritizeBusinessGoals());
    }

    public final String toString() {
        return ToString.builder((String)"PutPortfolioPreferencesRequest").add("ApplicationMode", (Object)this.applicationModeAsString()).add("ApplicationPreferences", (Object)this.applicationPreferences()).add("DatabasePreferences", (Object)this.databasePreferences()).add("PrioritizeBusinessGoals", (Object)this.prioritizeBusinessGoals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationMode": {
                return Optional.ofNullable(clazz.cast(this.applicationModeAsString()));
            }
            case "applicationPreferences": {
                return Optional.ofNullable(clazz.cast(this.applicationPreferences()));
            }
            case "databasePreferences": {
                return Optional.ofNullable(clazz.cast(this.databasePreferences()));
            }
            case "prioritizeBusinessGoals": {
                return Optional.ofNullable(clazz.cast(this.prioritizeBusinessGoals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationMode", APPLICATION_MODE_FIELD);
        map.put("applicationPreferences", APPLICATION_PREFERENCES_FIELD);
        map.put("databasePreferences", DATABASE_PREFERENCES_FIELD);
        map.put("prioritizeBusinessGoals", PRIORITIZE_BUSINESS_GOALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutPortfolioPreferencesRequest, T> g) {
        return obj -> g.apply((PutPortfolioPreferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyRequest.BuilderImpl
    implements Builder {
        private String applicationMode;
        private ApplicationPreferences applicationPreferences;
        private DatabasePreferences databasePreferences;
        private PrioritizeBusinessGoals prioritizeBusinessGoals;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPortfolioPreferencesRequest model) {
            super(model);
            this.applicationMode(model.applicationMode);
            this.applicationPreferences(model.applicationPreferences);
            this.databasePreferences(model.databasePreferences);
            this.prioritizeBusinessGoals(model.prioritizeBusinessGoals);
        }

        public final String getApplicationMode() {
            return this.applicationMode;
        }

        public final void setApplicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
        }

        @Override
        public final Builder applicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        @Override
        public final Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode(applicationMode == null ? null : applicationMode.toString());
            return this;
        }

        public final ApplicationPreferences.Builder getApplicationPreferences() {
            return this.applicationPreferences != null ? this.applicationPreferences.toBuilder() : null;
        }

        public final void setApplicationPreferences(ApplicationPreferences.BuilderImpl applicationPreferences) {
            this.applicationPreferences = applicationPreferences != null ? applicationPreferences.build() : null;
        }

        @Override
        public final Builder applicationPreferences(ApplicationPreferences applicationPreferences) {
            this.applicationPreferences = applicationPreferences;
            return this;
        }

        public final DatabasePreferences.Builder getDatabasePreferences() {
            return this.databasePreferences != null ? this.databasePreferences.toBuilder() : null;
        }

        public final void setDatabasePreferences(DatabasePreferences.BuilderImpl databasePreferences) {
            this.databasePreferences = databasePreferences != null ? databasePreferences.build() : null;
        }

        @Override
        public final Builder databasePreferences(DatabasePreferences databasePreferences) {
            this.databasePreferences = databasePreferences;
            return this;
        }

        public final PrioritizeBusinessGoals.Builder getPrioritizeBusinessGoals() {
            return this.prioritizeBusinessGoals != null ? this.prioritizeBusinessGoals.toBuilder() : null;
        }

        public final void setPrioritizeBusinessGoals(PrioritizeBusinessGoals.BuilderImpl prioritizeBusinessGoals) {
            this.prioritizeBusinessGoals = prioritizeBusinessGoals != null ? prioritizeBusinessGoals.build() : null;
        }

        @Override
        public final Builder prioritizeBusinessGoals(PrioritizeBusinessGoals prioritizeBusinessGoals) {
            this.prioritizeBusinessGoals = prioritizeBusinessGoals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPortfolioPreferencesRequest build() {
            return new PutPortfolioPreferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPortfolioPreferencesRequest> {
        public Builder applicationMode(String var1);

        public Builder applicationMode(ApplicationMode var1);

        public Builder applicationPreferences(ApplicationPreferences var1);

        default public Builder applicationPreferences(Consumer<ApplicationPreferences.Builder> applicationPreferences) {
            return this.applicationPreferences((ApplicationPreferences)((ApplicationPreferences.Builder)ApplicationPreferences.builder().applyMutation(applicationPreferences)).build());
        }

        public Builder databasePreferences(DatabasePreferences var1);

        default public Builder databasePreferences(Consumer<DatabasePreferences.Builder> databasePreferences) {
            return this.databasePreferences((DatabasePreferences)((DatabasePreferences.Builder)DatabasePreferences.builder().applyMutation(databasePreferences)).build());
        }

        public Builder prioritizeBusinessGoals(PrioritizeBusinessGoals var1);

        default public Builder prioritizeBusinessGoals(Consumer<PrioritizeBusinessGoals.Builder> prioritizeBusinessGoals) {
            return this.prioritizeBusinessGoals((PrioritizeBusinessGoals)((PrioritizeBusinessGoals.Builder)PrioritizeBusinessGoals.builder().applyMutation(prioritizeBusinessGoals)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

