/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceCodeRepository
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceCodeRepository> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branch").getter(SourceCodeRepository.getter(SourceCodeRepository::branch)).setter(SourceCodeRepository.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(SourceCodeRepository.getter(SourceCodeRepository::projectName)).setter(SourceCodeRepository.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(SourceCodeRepository.getter(SourceCodeRepository::repository)).setter(SourceCodeRepository.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> VERSION_CONTROL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionControlType").getter(SourceCodeRepository.getter(SourceCodeRepository::versionControlType)).setter(SourceCodeRepository.setter(Builder::versionControlType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionControlType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, PROJECT_NAME_FIELD, REPOSITORY_FIELD, VERSION_CONTROL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("branch", BRANCH_FIELD);
            this.put("projectName", PROJECT_NAME_FIELD);
            this.put("repository", REPOSITORY_FIELD);
            this.put("versionControlType", VERSION_CONTROL_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String branch;
    private final String projectName;
    private final String repository;
    private final String versionControlType;

    private SourceCodeRepository(BuilderImpl builder) {
        this.branch = builder.branch;
        this.projectName = builder.projectName;
        this.repository = builder.repository;
        this.versionControlType = builder.versionControlType;
    }

    public final String branch() {
        return this.branch;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String repository() {
        return this.repository;
    }

    public final String versionControlType() {
        return this.versionControlType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionControlType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCodeRepository)) {
            return false;
        }
        SourceCodeRepository other = (SourceCodeRepository)obj;
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.versionControlType(), other.versionControlType());
    }

    public final String toString() {
        return ToString.builder((String)"SourceCodeRepository").add("Branch", (Object)this.branch()).add("ProjectName", (Object)this.projectName()).add("Repository", (Object)this.repository()).add("VersionControlType", (Object)this.versionControlType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "versionControlType": {
                return Optional.ofNullable(clazz.cast(this.versionControlType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceCodeRepository, T> g) {
        return obj -> g.apply((SourceCodeRepository)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String branch;
        private String projectName;
        private String repository;
        private String versionControlType;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCodeRepository model) {
            this.branch(model.branch);
            this.projectName(model.projectName);
            this.repository(model.repository);
            this.versionControlType(model.versionControlType);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getVersionControlType() {
            return this.versionControlType;
        }

        public final void setVersionControlType(String versionControlType) {
            this.versionControlType = versionControlType;
        }

        @Override
        public final Builder versionControlType(String versionControlType) {
            this.versionControlType = versionControlType;
            return this;
        }

        public SourceCodeRepository build() {
            return new SourceCodeRepository(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceCodeRepository> {
        public Builder branch(String var1);

        public Builder projectName(String var1);

        public Builder repository(String var1);

        public Builder versionControlType(String var1);
    }
}

