/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerErrorCategory {
    CONNECTIVITY_ERROR("CONNECTIVITY_ERROR"),
    CREDENTIAL_ERROR("CREDENTIAL_ERROR"),
    PERMISSION_ERROR("PERMISSION_ERROR"),
    ARCHITECTURE_ERROR("ARCHITECTURE_ERROR"),
    OTHER_ERROR("OTHER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerErrorCategory> VALUE_MAP;
    private final String value;

    private ServerErrorCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerErrorCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerErrorCategory> knownValues() {
        EnumSet<ServerErrorCategory> knownValues = EnumSet.allOf(ServerErrorCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerErrorCategory.class, ServerErrorCategory::toString);
    }
}

