/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PipelineType {
    AZURE_DEVOPS("AZURE_DEVOPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PipelineType> VALUE_MAP;
    private final String value;

    private PipelineType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PipelineType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PipelineType> knownValues() {
        EnumSet<PipelineType> knownValues = EnumSet.allOf(PipelineType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PipelineType.class, PipelineType::toString);
    }
}

