/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Application preferences that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationPreferences.Builder, ApplicationPreferences> {
    private static final SdkField<ManagementPreference> MANAGEMENT_PREFERENCE_FIELD = SdkField
            .<ManagementPreference> builder(MarshallingType.SDK_POJO).memberName("managementPreference")
            .getter(getter(ApplicationPreferences::managementPreference)).setter(setter(Builder::managementPreference))
            .constructor(ManagementPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementPreference").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGEMENT_PREFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ManagementPreference managementPreference;

    private ApplicationPreferences(BuilderImpl builder) {
        this.managementPreference = builder.managementPreference;
    }

    /**
     * <p>
     * Application preferences that you specify to prefer managed environment.
     * </p>
     * 
     * @return Application preferences that you specify to prefer managed environment.
     */
    public final ManagementPreference managementPreference() {
        return managementPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(managementPreference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPreferences)) {
            return false;
        }
        ApplicationPreferences other = (ApplicationPreferences) obj;
        return Objects.equals(managementPreference(), other.managementPreference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationPreferences").add("ManagementPreference", managementPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "managementPreference":
            return Optional.ofNullable(clazz.cast(managementPreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationPreferences, T> g) {
        return obj -> g.apply((ApplicationPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationPreferences> {
        /**
         * <p>
         * Application preferences that you specify to prefer managed environment.
         * </p>
         * 
         * @param managementPreference
         *        Application preferences that you specify to prefer managed environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managementPreference(ManagementPreference managementPreference);

        /**
         * <p>
         * Application preferences that you specify to prefer managed environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagementPreference.Builder} avoiding
         * the need to create one manually via {@link ManagementPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagementPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #managementPreference(ManagementPreference)}.
         * 
         * @param managementPreference
         *        a consumer that will call methods on {@link ManagementPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managementPreference(ManagementPreference)
         */
        default Builder managementPreference(Consumer<ManagementPreference.Builder> managementPreference) {
            return managementPreference(ManagementPreference.builder().applyMutation(managementPreference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ManagementPreference managementPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPreferences model) {
            managementPreference(model.managementPreference);
        }

        public final ManagementPreference.Builder getManagementPreference() {
            return managementPreference != null ? managementPreference.toBuilder() : null;
        }

        public final void setManagementPreference(ManagementPreference.BuilderImpl managementPreference) {
            this.managementPreference = managementPreference != null ? managementPreference.build() : null;
        }

        @Override
        public final Builder managementPreference(ManagementPreference managementPreference) {
            this.managementPreference = managementPreference;
            return this;
        }

        @Override
        public ApplicationPreferences build() {
            return new ApplicationPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
