/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of the existing analyzers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzerNameUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyzerNameUnion.Builder, AnalyzerNameUnion> {
    private static final SdkField<String> BINARY_ANALYZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("binaryAnalyzerName").getter(getter(AnalyzerNameUnion::binaryAnalyzerNameAsString))
            .setter(setter(Builder::binaryAnalyzerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binaryAnalyzerName").build())
            .build();

    private static final SdkField<String> RUN_TIME_ANALYZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runTimeAnalyzerName").getter(getter(AnalyzerNameUnion::runTimeAnalyzerNameAsString))
            .setter(setter(Builder::runTimeAnalyzerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runTimeAnalyzerName").build())
            .build();

    private static final SdkField<String> SOURCE_CODE_ANALYZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCodeAnalyzerName").getter(getter(AnalyzerNameUnion::sourceCodeAnalyzerNameAsString))
            .setter(setter(Builder::sourceCodeAnalyzerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeAnalyzerName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BINARY_ANALYZER_NAME_FIELD,
            RUN_TIME_ANALYZER_NAME_FIELD, SOURCE_CODE_ANALYZER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String binaryAnalyzerName;

    private final String runTimeAnalyzerName;

    private final String sourceCodeAnalyzerName;

    private final Type type;

    private AnalyzerNameUnion(BuilderImpl builder) {
        this.binaryAnalyzerName = builder.binaryAnalyzerName;
        this.runTimeAnalyzerName = builder.runTimeAnalyzerName;
        this.sourceCodeAnalyzerName = builder.sourceCodeAnalyzerName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The binary analyzer names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #binaryAnalyzerName} will return {@link BinaryAnalyzerName#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #binaryAnalyzerNameAsString}.
     * </p>
     * 
     * @return The binary analyzer names.
     * @see BinaryAnalyzerName
     */
    public final BinaryAnalyzerName binaryAnalyzerName() {
        return BinaryAnalyzerName.fromValue(binaryAnalyzerName);
    }

    /**
     * <p>
     * The binary analyzer names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #binaryAnalyzerName} will return {@link BinaryAnalyzerName#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #binaryAnalyzerNameAsString}.
     * </p>
     * 
     * @return The binary analyzer names.
     * @see BinaryAnalyzerName
     */
    public final String binaryAnalyzerNameAsString() {
        return binaryAnalyzerName;
    }

    /**
     * <p>
     * The assessment analyzer names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runTimeAnalyzerName} will return {@link RunTimeAnalyzerName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #runTimeAnalyzerNameAsString}.
     * </p>
     * 
     * @return The assessment analyzer names.
     * @see RunTimeAnalyzerName
     */
    public final RunTimeAnalyzerName runTimeAnalyzerName() {
        return RunTimeAnalyzerName.fromValue(runTimeAnalyzerName);
    }

    /**
     * <p>
     * The assessment analyzer names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runTimeAnalyzerName} will return {@link RunTimeAnalyzerName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #runTimeAnalyzerNameAsString}.
     * </p>
     * 
     * @return The assessment analyzer names.
     * @see RunTimeAnalyzerName
     */
    public final String runTimeAnalyzerNameAsString() {
        return runTimeAnalyzerName;
    }

    /**
     * <p>
     * The source code analyzer names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceCodeAnalyzerName} will return {@link SourceCodeAnalyzerName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sourceCodeAnalyzerNameAsString}.
     * </p>
     * 
     * @return The source code analyzer names.
     * @see SourceCodeAnalyzerName
     */
    public final SourceCodeAnalyzerName sourceCodeAnalyzerName() {
        return SourceCodeAnalyzerName.fromValue(sourceCodeAnalyzerName);
    }

    /**
     * <p>
     * The source code analyzer names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceCodeAnalyzerName} will return {@link SourceCodeAnalyzerName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sourceCodeAnalyzerNameAsString}.
     * </p>
     * 
     * @return The source code analyzer names.
     * @see SourceCodeAnalyzerName
     */
    public final String sourceCodeAnalyzerNameAsString() {
        return sourceCodeAnalyzerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(binaryAnalyzerNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runTimeAnalyzerNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeAnalyzerNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzerNameUnion)) {
            return false;
        }
        AnalyzerNameUnion other = (AnalyzerNameUnion) obj;
        return Objects.equals(binaryAnalyzerNameAsString(), other.binaryAnalyzerNameAsString())
                && Objects.equals(runTimeAnalyzerNameAsString(), other.runTimeAnalyzerNameAsString())
                && Objects.equals(sourceCodeAnalyzerNameAsString(), other.sourceCodeAnalyzerNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzerNameUnion").add("BinaryAnalyzerName", binaryAnalyzerNameAsString())
                .add("RunTimeAnalyzerName", runTimeAnalyzerNameAsString())
                .add("SourceCodeAnalyzerName", sourceCodeAnalyzerNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "binaryAnalyzerName":
            return Optional.ofNullable(clazz.cast(binaryAnalyzerNameAsString()));
        case "runTimeAnalyzerName":
            return Optional.ofNullable(clazz.cast(runTimeAnalyzerNameAsString()));
        case "sourceCodeAnalyzerName":
            return Optional.ofNullable(clazz.cast(sourceCodeAnalyzerNameAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #binaryAnalyzerNameAsString()} initialized to the given value.
     *
     * <p>
     * The binary analyzer names.
     * </p>
     * 
     * @param binaryAnalyzerName
     *        The binary analyzer names.
     * @see BinaryAnalyzerName
     */
    public static AnalyzerNameUnion fromBinaryAnalyzerName(String binaryAnalyzerName) {
        return builder().binaryAnalyzerName(binaryAnalyzerName).build();
    }

    /**
     * Create an instance of this class with {@link #binaryAnalyzerNameAsString()} initialized to the given value.
     *
     * <p>
     * The binary analyzer names.
     * </p>
     * 
     * @param binaryAnalyzerName
     *        The binary analyzer names.
     * @see BinaryAnalyzerName
     */
    public static AnalyzerNameUnion fromBinaryAnalyzerName(BinaryAnalyzerName binaryAnalyzerName) {
        return builder().binaryAnalyzerName(binaryAnalyzerName).build();
    }

    /**
     * Create an instance of this class with {@link #runTimeAnalyzerNameAsString()} initialized to the given value.
     *
     * <p>
     * The assessment analyzer names.
     * </p>
     * 
     * @param runTimeAnalyzerName
     *        The assessment analyzer names.
     * @see RunTimeAnalyzerName
     */
    public static AnalyzerNameUnion fromRunTimeAnalyzerName(String runTimeAnalyzerName) {
        return builder().runTimeAnalyzerName(runTimeAnalyzerName).build();
    }

    /**
     * Create an instance of this class with {@link #runTimeAnalyzerNameAsString()} initialized to the given value.
     *
     * <p>
     * The assessment analyzer names.
     * </p>
     * 
     * @param runTimeAnalyzerName
     *        The assessment analyzer names.
     * @see RunTimeAnalyzerName
     */
    public static AnalyzerNameUnion fromRunTimeAnalyzerName(RunTimeAnalyzerName runTimeAnalyzerName) {
        return builder().runTimeAnalyzerName(runTimeAnalyzerName).build();
    }

    /**
     * Create an instance of this class with {@link #sourceCodeAnalyzerNameAsString()} initialized to the given value.
     *
     * <p>
     * The source code analyzer names.
     * </p>
     * 
     * @param sourceCodeAnalyzerName
     *        The source code analyzer names.
     * @see SourceCodeAnalyzerName
     */
    public static AnalyzerNameUnion fromSourceCodeAnalyzerName(String sourceCodeAnalyzerName) {
        return builder().sourceCodeAnalyzerName(sourceCodeAnalyzerName).build();
    }

    /**
     * Create an instance of this class with {@link #sourceCodeAnalyzerNameAsString()} initialized to the given value.
     *
     * <p>
     * The source code analyzer names.
     * </p>
     * 
     * @param sourceCodeAnalyzerName
     *        The source code analyzer names.
     * @see SourceCodeAnalyzerName
     */
    public static AnalyzerNameUnion fromSourceCodeAnalyzerName(SourceCodeAnalyzerName sourceCodeAnalyzerName) {
        return builder().sourceCodeAnalyzerName(sourceCodeAnalyzerName).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzerNameUnion, T> g) {
        return obj -> g.apply((AnalyzerNameUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyzerNameUnion> {
        /**
         * <p>
         * The binary analyzer names.
         * </p>
         * 
         * @param binaryAnalyzerName
         *        The binary analyzer names.
         * @see BinaryAnalyzerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BinaryAnalyzerName
         */
        Builder binaryAnalyzerName(String binaryAnalyzerName);

        /**
         * <p>
         * The binary analyzer names.
         * </p>
         * 
         * @param binaryAnalyzerName
         *        The binary analyzer names.
         * @see BinaryAnalyzerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BinaryAnalyzerName
         */
        Builder binaryAnalyzerName(BinaryAnalyzerName binaryAnalyzerName);

        /**
         * <p>
         * The assessment analyzer names.
         * </p>
         * 
         * @param runTimeAnalyzerName
         *        The assessment analyzer names.
         * @see RunTimeAnalyzerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunTimeAnalyzerName
         */
        Builder runTimeAnalyzerName(String runTimeAnalyzerName);

        /**
         * <p>
         * The assessment analyzer names.
         * </p>
         * 
         * @param runTimeAnalyzerName
         *        The assessment analyzer names.
         * @see RunTimeAnalyzerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunTimeAnalyzerName
         */
        Builder runTimeAnalyzerName(RunTimeAnalyzerName runTimeAnalyzerName);

        /**
         * <p>
         * The source code analyzer names.
         * </p>
         * 
         * @param sourceCodeAnalyzerName
         *        The source code analyzer names.
         * @see SourceCodeAnalyzerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceCodeAnalyzerName
         */
        Builder sourceCodeAnalyzerName(String sourceCodeAnalyzerName);

        /**
         * <p>
         * The source code analyzer names.
         * </p>
         * 
         * @param sourceCodeAnalyzerName
         *        The source code analyzer names.
         * @see SourceCodeAnalyzerName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceCodeAnalyzerName
         */
        Builder sourceCodeAnalyzerName(SourceCodeAnalyzerName sourceCodeAnalyzerName);
    }

    static final class BuilderImpl implements Builder {
        private String binaryAnalyzerName;

        private String runTimeAnalyzerName;

        private String sourceCodeAnalyzerName;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzerNameUnion model) {
            binaryAnalyzerName(model.binaryAnalyzerName);
            runTimeAnalyzerName(model.runTimeAnalyzerName);
            sourceCodeAnalyzerName(model.sourceCodeAnalyzerName);
        }

        public final String getBinaryAnalyzerName() {
            return binaryAnalyzerName;
        }

        public final void setBinaryAnalyzerName(String binaryAnalyzerName) {
            Object oldValue = this.binaryAnalyzerName;
            this.binaryAnalyzerName = binaryAnalyzerName;
            handleUnionValueChange(Type.BINARY_ANALYZER_NAME, oldValue, this.binaryAnalyzerName);
        }

        @Override
        public final Builder binaryAnalyzerName(String binaryAnalyzerName) {
            Object oldValue = this.binaryAnalyzerName;
            this.binaryAnalyzerName = binaryAnalyzerName;
            handleUnionValueChange(Type.BINARY_ANALYZER_NAME, oldValue, this.binaryAnalyzerName);
            return this;
        }

        @Override
        public final Builder binaryAnalyzerName(BinaryAnalyzerName binaryAnalyzerName) {
            this.binaryAnalyzerName(binaryAnalyzerName == null ? null : binaryAnalyzerName.toString());
            return this;
        }

        public final String getRunTimeAnalyzerName() {
            return runTimeAnalyzerName;
        }

        public final void setRunTimeAnalyzerName(String runTimeAnalyzerName) {
            Object oldValue = this.runTimeAnalyzerName;
            this.runTimeAnalyzerName = runTimeAnalyzerName;
            handleUnionValueChange(Type.RUN_TIME_ANALYZER_NAME, oldValue, this.runTimeAnalyzerName);
        }

        @Override
        public final Builder runTimeAnalyzerName(String runTimeAnalyzerName) {
            Object oldValue = this.runTimeAnalyzerName;
            this.runTimeAnalyzerName = runTimeAnalyzerName;
            handleUnionValueChange(Type.RUN_TIME_ANALYZER_NAME, oldValue, this.runTimeAnalyzerName);
            return this;
        }

        @Override
        public final Builder runTimeAnalyzerName(RunTimeAnalyzerName runTimeAnalyzerName) {
            this.runTimeAnalyzerName(runTimeAnalyzerName == null ? null : runTimeAnalyzerName.toString());
            return this;
        }

        public final String getSourceCodeAnalyzerName() {
            return sourceCodeAnalyzerName;
        }

        public final void setSourceCodeAnalyzerName(String sourceCodeAnalyzerName) {
            Object oldValue = this.sourceCodeAnalyzerName;
            this.sourceCodeAnalyzerName = sourceCodeAnalyzerName;
            handleUnionValueChange(Type.SOURCE_CODE_ANALYZER_NAME, oldValue, this.sourceCodeAnalyzerName);
        }

        @Override
        public final Builder sourceCodeAnalyzerName(String sourceCodeAnalyzerName) {
            Object oldValue = this.sourceCodeAnalyzerName;
            this.sourceCodeAnalyzerName = sourceCodeAnalyzerName;
            handleUnionValueChange(Type.SOURCE_CODE_ANALYZER_NAME, oldValue, this.sourceCodeAnalyzerName);
            return this;
        }

        @Override
        public final Builder sourceCodeAnalyzerName(SourceCodeAnalyzerName sourceCodeAnalyzerName) {
            this.sourceCodeAnalyzerName(sourceCodeAnalyzerName == null ? null : sourceCodeAnalyzerName.toString());
            return this;
        }

        @Override
        public AnalyzerNameUnion build() {
            return new AnalyzerNameUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AnalyzerNameUnion#type()
     */
    public enum Type {
        BINARY_ANALYZER_NAME,

        RUN_TIME_ANALYZER_NAME,

        SOURCE_CODE_ANALYZER_NAME,

        UNKNOWN_TO_SDK_VERSION
    }
}
