/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StrategyRecommendation {
    RECOMMENDED("recommended"),
    VIABLE_OPTION("viableOption"),
    NOT_RECOMMENDED("notRecommended"),
    POTENTIAL("potential"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StrategyRecommendation> VALUE_MAP;
    private final String value;

    private StrategyRecommendation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StrategyRecommendation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StrategyRecommendation> knownValues() {
        EnumSet<StrategyRecommendation> knownValues = EnumSet.allOf(StrategyRecommendation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StrategyRecommendation.class, StrategyRecommendation::toString);
    }
}

