/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyClient;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerDetail;

public class ListServersIterable
implements SdkIterable<ListServersResponse> {
    private final MigrationHubStrategyClient client;
    private final ListServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServersIterable(MigrationHubStrategyClient client, ListServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServersResponseFetcher();
    }

    public Iterator<ListServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServerDetail> serverInfos() {
        Function<ListServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverInfos() != null) {
                return response.serverInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServersResponseFetcher
    implements SyncPageFetcher<ListServersResponse> {
        private ListServersResponseFetcher() {
        }

        public boolean hasNextPage(ListServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServersResponse nextPage(ListServersResponse previousPage) {
            if (previousPage == null) {
                return ListServersIterable.this.client.listServers(ListServersIterable.this.firstRequest);
            }
            return ListServersIterable.this.client.listServers((ListServersRequest)((Object)ListServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

