/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentSummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAntipatternSeveritySummaryCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentSummaryCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServerSummaryCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListStrategySummaryCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.S3Object;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerSummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentSummary> {
    private static final SdkField<S3Object> ANTIPATTERN_REPORT_S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antipatternReportS3Object").getter(AssessmentSummary.getter(AssessmentSummary::antipatternReportS3Object)).setter(AssessmentSummary.setter(Builder::antipatternReportS3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportS3Object").build()}).build();
    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("antipatternReportStatus").getter(AssessmentSummary.getter(AssessmentSummary::antipatternReportStatusAsString)).setter(AssessmentSummary.setter(Builder::antipatternReportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatus").build()}).build();
    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("antipatternReportStatusMessage").getter(AssessmentSummary.getter(AssessmentSummary::antipatternReportStatusMessage)).setter(AssessmentSummary.setter(Builder::antipatternReportStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatusMessage").build()}).build();
    private static final SdkField<Instant> LAST_ANALYZED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAnalyzedTimestamp").getter(AssessmentSummary.getter(AssessmentSummary::lastAnalyzedTimestamp)).setter(AssessmentSummary.setter(Builder::lastAnalyzedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAnalyzedTimestamp").build()}).build();
    private static final SdkField<List<AntipatternSeveritySummary>> LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listAntipatternSeveritySummary").getter(AssessmentSummary.getter(AssessmentSummary::listAntipatternSeveritySummary)).setter(AssessmentSummary.setter(Builder::listAntipatternSeveritySummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAntipatternSeveritySummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AntipatternSeveritySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StrategySummary>> LIST_APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listApplicationComponentStrategySummary").getter(AssessmentSummary.getter(AssessmentSummary::listApplicationComponentStrategySummary)).setter(AssessmentSummary.setter(Builder::listApplicationComponentStrategySummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listApplicationComponentStrategySummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StrategySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ApplicationComponentSummary>> LIST_APPLICATION_COMPONENT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listApplicationComponentSummary").getter(AssessmentSummary.getter(AssessmentSummary::listApplicationComponentSummary)).setter(AssessmentSummary.setter(Builder::listApplicationComponentSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listApplicationComponentSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationComponentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StrategySummary>> LIST_SERVER_STRATEGY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listServerStrategySummary").getter(AssessmentSummary.getter(AssessmentSummary::listServerStrategySummary)).setter(AssessmentSummary.setter(Builder::listServerStrategySummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listServerStrategySummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StrategySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServerSummary>> LIST_SERVER_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listServerSummary").getter(AssessmentSummary.getter(AssessmentSummary::listServerSummary)).setter(AssessmentSummary.setter(Builder::listServerSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listServerSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANTIPATTERN_REPORT_S3_OBJECT_FIELD, ANTIPATTERN_REPORT_STATUS_FIELD, ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD, LAST_ANALYZED_TIMESTAMP_FIELD, LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD, LIST_APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD, LIST_APPLICATION_COMPONENT_SUMMARY_FIELD, LIST_SERVER_STRATEGY_SUMMARY_FIELD, LIST_SERVER_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3Object antipatternReportS3Object;
    private final String antipatternReportStatus;
    private final String antipatternReportStatusMessage;
    private final Instant lastAnalyzedTimestamp;
    private final List<AntipatternSeveritySummary> listAntipatternSeveritySummary;
    private final List<StrategySummary> listApplicationComponentStrategySummary;
    private final List<ApplicationComponentSummary> listApplicationComponentSummary;
    private final List<StrategySummary> listServerStrategySummary;
    private final List<ServerSummary> listServerSummary;

    private AssessmentSummary(BuilderImpl builder) {
        this.antipatternReportS3Object = builder.antipatternReportS3Object;
        this.antipatternReportStatus = builder.antipatternReportStatus;
        this.antipatternReportStatusMessage = builder.antipatternReportStatusMessage;
        this.lastAnalyzedTimestamp = builder.lastAnalyzedTimestamp;
        this.listAntipatternSeveritySummary = builder.listAntipatternSeveritySummary;
        this.listApplicationComponentStrategySummary = builder.listApplicationComponentStrategySummary;
        this.listApplicationComponentSummary = builder.listApplicationComponentSummary;
        this.listServerStrategySummary = builder.listServerStrategySummary;
        this.listServerSummary = builder.listServerSummary;
    }

    public final S3Object antipatternReportS3Object() {
        return this.antipatternReportS3Object;
    }

    public final AntipatternReportStatus antipatternReportStatus() {
        return AntipatternReportStatus.fromValue(this.antipatternReportStatus);
    }

    public final String antipatternReportStatusAsString() {
        return this.antipatternReportStatus;
    }

    public final String antipatternReportStatusMessage() {
        return this.antipatternReportStatusMessage;
    }

    public final Instant lastAnalyzedTimestamp() {
        return this.lastAnalyzedTimestamp;
    }

    public final boolean hasListAntipatternSeveritySummary() {
        return this.listAntipatternSeveritySummary != null && !(this.listAntipatternSeveritySummary instanceof SdkAutoConstructList);
    }

    public final List<AntipatternSeveritySummary> listAntipatternSeveritySummary() {
        return this.listAntipatternSeveritySummary;
    }

    public final boolean hasListApplicationComponentStrategySummary() {
        return this.listApplicationComponentStrategySummary != null && !(this.listApplicationComponentStrategySummary instanceof SdkAutoConstructList);
    }

    public final List<StrategySummary> listApplicationComponentStrategySummary() {
        return this.listApplicationComponentStrategySummary;
    }

    public final boolean hasListApplicationComponentSummary() {
        return this.listApplicationComponentSummary != null && !(this.listApplicationComponentSummary instanceof SdkAutoConstructList);
    }

    public final List<ApplicationComponentSummary> listApplicationComponentSummary() {
        return this.listApplicationComponentSummary;
    }

    public final boolean hasListServerStrategySummary() {
        return this.listServerStrategySummary != null && !(this.listServerStrategySummary instanceof SdkAutoConstructList);
    }

    public final List<StrategySummary> listServerStrategySummary() {
        return this.listServerStrategySummary;
    }

    public final boolean hasListServerSummary() {
        return this.listServerSummary != null && !(this.listServerSummary instanceof SdkAutoConstructList);
    }

    public final List<ServerSummary> listServerSummary() {
        return this.listServerSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAnalyzedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListAntipatternSeveritySummary() ? this.listAntipatternSeveritySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListApplicationComponentStrategySummary() ? this.listApplicationComponentStrategySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListApplicationComponentSummary() ? this.listApplicationComponentSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListServerStrategySummary() ? this.listServerStrategySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListServerSummary() ? this.listServerSummary() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentSummary)) {
            return false;
        }
        AssessmentSummary other = (AssessmentSummary)obj;
        return Objects.equals(this.antipatternReportS3Object(), other.antipatternReportS3Object()) && Objects.equals(this.antipatternReportStatusAsString(), other.antipatternReportStatusAsString()) && Objects.equals(this.antipatternReportStatusMessage(), other.antipatternReportStatusMessage()) && Objects.equals(this.lastAnalyzedTimestamp(), other.lastAnalyzedTimestamp()) && this.hasListAntipatternSeveritySummary() == other.hasListAntipatternSeveritySummary() && Objects.equals(this.listAntipatternSeveritySummary(), other.listAntipatternSeveritySummary()) && this.hasListApplicationComponentStrategySummary() == other.hasListApplicationComponentStrategySummary() && Objects.equals(this.listApplicationComponentStrategySummary(), other.listApplicationComponentStrategySummary()) && this.hasListApplicationComponentSummary() == other.hasListApplicationComponentSummary() && Objects.equals(this.listApplicationComponentSummary(), other.listApplicationComponentSummary()) && this.hasListServerStrategySummary() == other.hasListServerStrategySummary() && Objects.equals(this.listServerStrategySummary(), other.listServerStrategySummary()) && this.hasListServerSummary() == other.hasListServerSummary() && Objects.equals(this.listServerSummary(), other.listServerSummary());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentSummary").add("AntipatternReportS3Object", (Object)this.antipatternReportS3Object()).add("AntipatternReportStatus", (Object)this.antipatternReportStatusAsString()).add("AntipatternReportStatusMessage", (Object)this.antipatternReportStatusMessage()).add("LastAnalyzedTimestamp", (Object)this.lastAnalyzedTimestamp()).add("ListAntipatternSeveritySummary", this.hasListAntipatternSeveritySummary() ? this.listAntipatternSeveritySummary() : null).add("ListApplicationComponentStrategySummary", this.hasListApplicationComponentStrategySummary() ? this.listApplicationComponentStrategySummary() : null).add("ListApplicationComponentSummary", this.hasListApplicationComponentSummary() ? this.listApplicationComponentSummary() : null).add("ListServerStrategySummary", this.hasListServerStrategySummary() ? this.listServerStrategySummary() : null).add("ListServerSummary", this.hasListServerSummary() ? this.listServerSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "antipatternReportS3Object": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportS3Object()));
            }
            case "antipatternReportStatus": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportStatusAsString()));
            }
            case "antipatternReportStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportStatusMessage()));
            }
            case "lastAnalyzedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastAnalyzedTimestamp()));
            }
            case "listAntipatternSeveritySummary": {
                return Optional.ofNullable(clazz.cast(this.listAntipatternSeveritySummary()));
            }
            case "listApplicationComponentStrategySummary": {
                return Optional.ofNullable(clazz.cast(this.listApplicationComponentStrategySummary()));
            }
            case "listApplicationComponentSummary": {
                return Optional.ofNullable(clazz.cast(this.listApplicationComponentSummary()));
            }
            case "listServerStrategySummary": {
                return Optional.ofNullable(clazz.cast(this.listServerStrategySummary()));
            }
            case "listServerSummary": {
                return Optional.ofNullable(clazz.cast(this.listServerSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentSummary, T> g) {
        return obj -> g.apply((AssessmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Object antipatternReportS3Object;
        private String antipatternReportStatus;
        private String antipatternReportStatusMessage;
        private Instant lastAnalyzedTimestamp;
        private List<AntipatternSeveritySummary> listAntipatternSeveritySummary = DefaultSdkAutoConstructList.getInstance();
        private List<StrategySummary> listApplicationComponentStrategySummary = DefaultSdkAutoConstructList.getInstance();
        private List<ApplicationComponentSummary> listApplicationComponentSummary = DefaultSdkAutoConstructList.getInstance();
        private List<StrategySummary> listServerStrategySummary = DefaultSdkAutoConstructList.getInstance();
        private List<ServerSummary> listServerSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentSummary model) {
            this.antipatternReportS3Object(model.antipatternReportS3Object);
            this.antipatternReportStatus(model.antipatternReportStatus);
            this.antipatternReportStatusMessage(model.antipatternReportStatusMessage);
            this.lastAnalyzedTimestamp(model.lastAnalyzedTimestamp);
            this.listAntipatternSeveritySummary(model.listAntipatternSeveritySummary);
            this.listApplicationComponentStrategySummary(model.listApplicationComponentStrategySummary);
            this.listApplicationComponentSummary(model.listApplicationComponentSummary);
            this.listServerStrategySummary(model.listServerStrategySummary);
            this.listServerSummary(model.listServerSummary);
        }

        public final S3Object.Builder getAntipatternReportS3Object() {
            return this.antipatternReportS3Object != null ? this.antipatternReportS3Object.toBuilder() : null;
        }

        public final void setAntipatternReportS3Object(S3Object.BuilderImpl antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object != null ? antipatternReportS3Object.build() : null;
        }

        @Override
        public final Builder antipatternReportS3Object(S3Object antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object;
            return this;
        }

        public final String getAntipatternReportStatus() {
            return this.antipatternReportStatus;
        }

        public final void setAntipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
        }

        @Override
        public final Builder antipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
            return this;
        }

        @Override
        public final Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus) {
            this.antipatternReportStatus(antipatternReportStatus == null ? null : antipatternReportStatus.toString());
            return this;
        }

        public final String getAntipatternReportStatusMessage() {
            return this.antipatternReportStatusMessage;
        }

        public final void setAntipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
        }

        @Override
        public final Builder antipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
            return this;
        }

        public final Instant getLastAnalyzedTimestamp() {
            return this.lastAnalyzedTimestamp;
        }

        public final void setLastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
        }

        @Override
        public final Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
            return this;
        }

        public final List<AntipatternSeveritySummary.Builder> getListAntipatternSeveritySummary() {
            List<AntipatternSeveritySummary.Builder> result = ListAntipatternSeveritySummaryCopier.copyToBuilder(this.listAntipatternSeveritySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListAntipatternSeveritySummary(Collection<AntipatternSeveritySummary.BuilderImpl> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copyFromBuilder(listAntipatternSeveritySummary);
        }

        @Override
        public final Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copy(listAntipatternSeveritySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(AntipatternSeveritySummary ... listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary(Arrays.asList(listAntipatternSeveritySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder> ... listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary(Stream.of(listAntipatternSeveritySummary).map(c -> (AntipatternSeveritySummary)((AntipatternSeveritySummary.Builder)AntipatternSeveritySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StrategySummary.Builder> getListApplicationComponentStrategySummary() {
            List<StrategySummary.Builder> result = ListStrategySummaryCopier.copyToBuilder(this.listApplicationComponentStrategySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListApplicationComponentStrategySummary(Collection<StrategySummary.BuilderImpl> listApplicationComponentStrategySummary) {
            this.listApplicationComponentStrategySummary = ListStrategySummaryCopier.copyFromBuilder(listApplicationComponentStrategySummary);
        }

        @Override
        public final Builder listApplicationComponentStrategySummary(Collection<StrategySummary> listApplicationComponentStrategySummary) {
            this.listApplicationComponentStrategySummary = ListStrategySummaryCopier.copy(listApplicationComponentStrategySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentStrategySummary(StrategySummary ... listApplicationComponentStrategySummary) {
            this.listApplicationComponentStrategySummary(Arrays.asList(listApplicationComponentStrategySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentStrategySummary(Consumer<StrategySummary.Builder> ... listApplicationComponentStrategySummary) {
            this.listApplicationComponentStrategySummary(Stream.of(listApplicationComponentStrategySummary).map(c -> (StrategySummary)((StrategySummary.Builder)StrategySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ApplicationComponentSummary.Builder> getListApplicationComponentSummary() {
            List<ApplicationComponentSummary.Builder> result = ListApplicationComponentSummaryCopier.copyToBuilder(this.listApplicationComponentSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListApplicationComponentSummary(Collection<ApplicationComponentSummary.BuilderImpl> listApplicationComponentSummary) {
            this.listApplicationComponentSummary = ListApplicationComponentSummaryCopier.copyFromBuilder(listApplicationComponentSummary);
        }

        @Override
        public final Builder listApplicationComponentSummary(Collection<ApplicationComponentSummary> listApplicationComponentSummary) {
            this.listApplicationComponentSummary = ListApplicationComponentSummaryCopier.copy(listApplicationComponentSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentSummary(ApplicationComponentSummary ... listApplicationComponentSummary) {
            this.listApplicationComponentSummary(Arrays.asList(listApplicationComponentSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listApplicationComponentSummary(Consumer<ApplicationComponentSummary.Builder> ... listApplicationComponentSummary) {
            this.listApplicationComponentSummary(Stream.of(listApplicationComponentSummary).map(c -> (ApplicationComponentSummary)((ApplicationComponentSummary.Builder)ApplicationComponentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StrategySummary.Builder> getListServerStrategySummary() {
            List<StrategySummary.Builder> result = ListStrategySummaryCopier.copyToBuilder(this.listServerStrategySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListServerStrategySummary(Collection<StrategySummary.BuilderImpl> listServerStrategySummary) {
            this.listServerStrategySummary = ListStrategySummaryCopier.copyFromBuilder(listServerStrategySummary);
        }

        @Override
        public final Builder listServerStrategySummary(Collection<StrategySummary> listServerStrategySummary) {
            this.listServerStrategySummary = ListStrategySummaryCopier.copy(listServerStrategySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerStrategySummary(StrategySummary ... listServerStrategySummary) {
            this.listServerStrategySummary(Arrays.asList(listServerStrategySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerStrategySummary(Consumer<StrategySummary.Builder> ... listServerStrategySummary) {
            this.listServerStrategySummary(Stream.of(listServerStrategySummary).map(c -> (StrategySummary)((StrategySummary.Builder)StrategySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServerSummary.Builder> getListServerSummary() {
            List<ServerSummary.Builder> result = ListServerSummaryCopier.copyToBuilder(this.listServerSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListServerSummary(Collection<ServerSummary.BuilderImpl> listServerSummary) {
            this.listServerSummary = ListServerSummaryCopier.copyFromBuilder(listServerSummary);
        }

        @Override
        public final Builder listServerSummary(Collection<ServerSummary> listServerSummary) {
            this.listServerSummary = ListServerSummaryCopier.copy(listServerSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerSummary(ServerSummary ... listServerSummary) {
            this.listServerSummary(Arrays.asList(listServerSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listServerSummary(Consumer<ServerSummary.Builder> ... listServerSummary) {
            this.listServerSummary(Stream.of(listServerSummary).map(c -> (ServerSummary)((ServerSummary.Builder)ServerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssessmentSummary build() {
            return new AssessmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentSummary> {
        public Builder antipatternReportS3Object(S3Object var1);

        default public Builder antipatternReportS3Object(Consumer<S3Object.Builder> antipatternReportS3Object) {
            return this.antipatternReportS3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(antipatternReportS3Object)).build());
        }

        public Builder antipatternReportStatus(String var1);

        public Builder antipatternReportStatus(AntipatternReportStatus var1);

        public Builder antipatternReportStatusMessage(String var1);

        public Builder lastAnalyzedTimestamp(Instant var1);

        public Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> var1);

        public Builder listAntipatternSeveritySummary(AntipatternSeveritySummary ... var1);

        public Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder> ... var1);

        public Builder listApplicationComponentStrategySummary(Collection<StrategySummary> var1);

        public Builder listApplicationComponentStrategySummary(StrategySummary ... var1);

        public Builder listApplicationComponentStrategySummary(Consumer<StrategySummary.Builder> ... var1);

        public Builder listApplicationComponentSummary(Collection<ApplicationComponentSummary> var1);

        public Builder listApplicationComponentSummary(ApplicationComponentSummary ... var1);

        public Builder listApplicationComponentSummary(Consumer<ApplicationComponentSummary.Builder> ... var1);

        public Builder listServerStrategySummary(Collection<StrategySummary> var1);

        public Builder listServerStrategySummary(StrategySummary ... var1);

        public Builder listServerStrategySummary(Consumer<StrategySummary.Builder> ... var1);

        public Builder listServerSummary(Collection<ServerSummary> var1);

        public Builder listServerSummary(ServerSummary ... var1);

        public Builder listServerSummary(Consumer<ServerSummary.Builder> ... var1);
    }
}

