/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyAsyncClient;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse;

public class GetServerDetailsPublisher
implements SdkPublisher<GetServerDetailsResponse> {
    private final MigrationHubStrategyAsyncClient client;
    private final GetServerDetailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetServerDetailsPublisher(MigrationHubStrategyAsyncClient client, GetServerDetailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetServerDetailsPublisher(MigrationHubStrategyAsyncClient client, GetServerDetailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetServerDetailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetServerDetailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssociatedApplication> associatedApplications() {
        Function<GetServerDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associatedApplications() != null) {
                return response.associatedApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetServerDetailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetServerDetailsResponseFetcher
    implements AsyncPageFetcher<GetServerDetailsResponse> {
        private GetServerDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetServerDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetServerDetailsResponse> nextPage(GetServerDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetServerDetailsPublisher.this.client.getServerDetails(GetServerDetailsPublisher.this.firstRequest);
            }
            return GetServerDetailsPublisher.this.client.getServerDetails((GetServerDetailsRequest)((Object)GetServerDetailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

