/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubstrategy.model.AwsManagedResources;
import software.amazon.awssdk.services.migrationhubstrategy.model.NoManagementPreference;
import software.amazon.awssdk.services.migrationhubstrategy.model.SelfManageResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagementPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagementPreference> {
    private static final SdkField<AwsManagedResources> AWS_MANAGED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsManagedResources").getter(ManagementPreference.getter(ManagementPreference::awsManagedResources)).setter(ManagementPreference.setter(Builder::awsManagedResources)).constructor(AwsManagedResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsManagedResources").build()}).build();
    private static final SdkField<NoManagementPreference> NO_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("noPreference").getter(ManagementPreference.getter(ManagementPreference::noPreference)).setter(ManagementPreference.setter(Builder::noPreference)).constructor(NoManagementPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noPreference").build()}).build();
    private static final SdkField<SelfManageResources> SELF_MANAGE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("selfManageResources").getter(ManagementPreference.getter(ManagementPreference::selfManageResources)).setter(ManagementPreference.setter(Builder::selfManageResources)).constructor(SelfManageResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfManageResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_MANAGED_RESOURCES_FIELD, NO_PREFERENCE_FIELD, SELF_MANAGE_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsManagedResources awsManagedResources;
    private final NoManagementPreference noPreference;
    private final SelfManageResources selfManageResources;
    private final Type type;

    private ManagementPreference(BuilderImpl builder) {
        this.awsManagedResources = builder.awsManagedResources;
        this.noPreference = builder.noPreference;
        this.selfManageResources = builder.selfManageResources;
        this.type = builder.type;
    }

    public final AwsManagedResources awsManagedResources() {
        return this.awsManagedResources;
    }

    public final NoManagementPreference noPreference() {
        return this.noPreference;
    }

    public final SelfManageResources selfManageResources() {
        return this.selfManageResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsManagedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.noPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManageResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagementPreference)) {
            return false;
        }
        ManagementPreference other = (ManagementPreference)obj;
        return Objects.equals(this.awsManagedResources(), other.awsManagedResources()) && Objects.equals(this.noPreference(), other.noPreference()) && Objects.equals(this.selfManageResources(), other.selfManageResources());
    }

    public final String toString() {
        return ToString.builder((String)"ManagementPreference").add("AwsManagedResources", (Object)this.awsManagedResources()).add("NoPreference", (Object)this.noPreference()).add("SelfManageResources", (Object)this.selfManageResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsManagedResources": {
                return Optional.ofNullable(clazz.cast(this.awsManagedResources()));
            }
            case "noPreference": {
                return Optional.ofNullable(clazz.cast(this.noPreference()));
            }
            case "selfManageResources": {
                return Optional.ofNullable(clazz.cast(this.selfManageResources()));
            }
        }
        return Optional.empty();
    }

    public static ManagementPreference fromAwsManagedResources(AwsManagedResources awsManagedResources) {
        return (ManagementPreference)ManagementPreference.builder().awsManagedResources(awsManagedResources).build();
    }

    public static ManagementPreference fromAwsManagedResources(Consumer<AwsManagedResources.Builder> awsManagedResources) {
        AwsManagedResources.Builder builder = AwsManagedResources.builder();
        awsManagedResources.accept(builder);
        return ManagementPreference.fromAwsManagedResources((AwsManagedResources)builder.build());
    }

    public static ManagementPreference fromNoPreference(NoManagementPreference noPreference) {
        return (ManagementPreference)ManagementPreference.builder().noPreference(noPreference).build();
    }

    public static ManagementPreference fromNoPreference(Consumer<NoManagementPreference.Builder> noPreference) {
        NoManagementPreference.Builder builder = NoManagementPreference.builder();
        noPreference.accept(builder);
        return ManagementPreference.fromNoPreference((NoManagementPreference)builder.build());
    }

    public static ManagementPreference fromSelfManageResources(SelfManageResources selfManageResources) {
        return (ManagementPreference)ManagementPreference.builder().selfManageResources(selfManageResources).build();
    }

    public static ManagementPreference fromSelfManageResources(Consumer<SelfManageResources.Builder> selfManageResources) {
        SelfManageResources.Builder builder = SelfManageResources.builder();
        selfManageResources.accept(builder);
        return ManagementPreference.fromSelfManageResources((SelfManageResources)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagementPreference, T> g) {
        return obj -> g.apply((ManagementPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AWS_MANAGED_RESOURCES,
        NO_PREFERENCE,
        SELF_MANAGE_RESOURCES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AwsManagedResources awsManagedResources;
        private NoManagementPreference noPreference;
        private SelfManageResources selfManageResources;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ManagementPreference model) {
            this.awsManagedResources(model.awsManagedResources);
            this.noPreference(model.noPreference);
            this.selfManageResources(model.selfManageResources);
        }

        public final AwsManagedResources.Builder getAwsManagedResources() {
            return this.awsManagedResources != null ? this.awsManagedResources.toBuilder() : null;
        }

        public final void setAwsManagedResources(AwsManagedResources.BuilderImpl awsManagedResources) {
            AwsManagedResources oldValue = this.awsManagedResources;
            this.awsManagedResources = awsManagedResources != null ? awsManagedResources.build() : null;
            this.handleUnionValueChange(Type.AWS_MANAGED_RESOURCES, oldValue, this.awsManagedResources);
        }

        @Override
        @Transient
        public final Builder awsManagedResources(AwsManagedResources awsManagedResources) {
            AwsManagedResources oldValue = this.awsManagedResources;
            this.awsManagedResources = awsManagedResources;
            this.handleUnionValueChange(Type.AWS_MANAGED_RESOURCES, oldValue, this.awsManagedResources);
            return this;
        }

        public final NoManagementPreference.Builder getNoPreference() {
            return this.noPreference != null ? this.noPreference.toBuilder() : null;
        }

        public final void setNoPreference(NoManagementPreference.BuilderImpl noPreference) {
            NoManagementPreference oldValue = this.noPreference;
            this.noPreference = noPreference != null ? noPreference.build() : null;
            this.handleUnionValueChange(Type.NO_PREFERENCE, oldValue, this.noPreference);
        }

        @Override
        @Transient
        public final Builder noPreference(NoManagementPreference noPreference) {
            NoManagementPreference oldValue = this.noPreference;
            this.noPreference = noPreference;
            this.handleUnionValueChange(Type.NO_PREFERENCE, oldValue, this.noPreference);
            return this;
        }

        public final SelfManageResources.Builder getSelfManageResources() {
            return this.selfManageResources != null ? this.selfManageResources.toBuilder() : null;
        }

        public final void setSelfManageResources(SelfManageResources.BuilderImpl selfManageResources) {
            SelfManageResources oldValue = this.selfManageResources;
            this.selfManageResources = selfManageResources != null ? selfManageResources.build() : null;
            this.handleUnionValueChange(Type.SELF_MANAGE_RESOURCES, oldValue, this.selfManageResources);
        }

        @Override
        @Transient
        public final Builder selfManageResources(SelfManageResources selfManageResources) {
            SelfManageResources oldValue = this.selfManageResources;
            this.selfManageResources = selfManageResources;
            this.handleUnionValueChange(Type.SELF_MANAGE_RESOURCES, oldValue, this.selfManageResources);
            return this;
        }

        public ManagementPreference build() {
            return new ManagementPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagementPreference> {
        public Builder awsManagedResources(AwsManagedResources var1);

        default public Builder awsManagedResources(Consumer<AwsManagedResources.Builder> awsManagedResources) {
            return this.awsManagedResources((AwsManagedResources)((AwsManagedResources.Builder)AwsManagedResources.builder().applyMutation(awsManagedResources)).build());
        }

        public Builder noPreference(NoManagementPreference var1);

        default public Builder noPreference(Consumer<NoManagementPreference.Builder> noPreference) {
            return this.noPreference((NoManagementPreference)((NoManagementPreference.Builder)NoManagementPreference.builder().applyMutation(noPreference)).build());
        }

        public Builder selfManageResources(SelfManageResources var1);

        default public Builder selfManageResources(Consumer<SelfManageResources.Builder> selfManageResources) {
            return this.selfManageResources((SelfManageResources)((SelfManageResources.Builder)SelfManageResources.builder().applyMutation(selfManageResources)).build());
        }
    }
}

