/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.NetworkInfo;
import software.amazon.awssdk.services.migrationhubstrategy.model.NetworkInfoListCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.OSInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemInfo> {
    private static final SdkField<String> CPU_ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpuArchitecture").getter(SystemInfo.getter(SystemInfo::cpuArchitecture)).setter(SystemInfo.setter(Builder::cpuArchitecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitecture").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystemType").getter(SystemInfo.getter(SystemInfo::fileSystemType)).setter(SystemInfo.setter(Builder::fileSystemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemType").build()}).build();
    private static final SdkField<List<NetworkInfo>> NETWORK_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInfoList").getter(SystemInfo.getter(SystemInfo::networkInfoList)).setter(SystemInfo.setter(Builder::networkInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OSInfo> OS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("osInfo").getter(SystemInfo.getter(SystemInfo::osInfo)).setter(SystemInfo.setter(Builder::osInfo)).constructor(OSInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_ARCHITECTURE_FIELD, FILE_SYSTEM_TYPE_FIELD, NETWORK_INFO_LIST_FIELD, OS_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cpuArchitecture;
    private final String fileSystemType;
    private final List<NetworkInfo> networkInfoList;
    private final OSInfo osInfo;

    private SystemInfo(BuilderImpl builder) {
        this.cpuArchitecture = builder.cpuArchitecture;
        this.fileSystemType = builder.fileSystemType;
        this.networkInfoList = builder.networkInfoList;
        this.osInfo = builder.osInfo;
    }

    public final String cpuArchitecture() {
        return this.cpuArchitecture;
    }

    public final String fileSystemType() {
        return this.fileSystemType;
    }

    public final boolean hasNetworkInfoList() {
        return this.networkInfoList != null && !(this.networkInfoList instanceof SdkAutoConstructList);
    }

    public final List<NetworkInfo> networkInfoList() {
        return this.networkInfoList;
    }

    public final OSInfo osInfo() {
        return this.osInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuArchitecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInfoList() ? this.networkInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.osInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInfo)) {
            return false;
        }
        SystemInfo other = (SystemInfo)obj;
        return Objects.equals(this.cpuArchitecture(), other.cpuArchitecture()) && Objects.equals(this.fileSystemType(), other.fileSystemType()) && this.hasNetworkInfoList() == other.hasNetworkInfoList() && Objects.equals(this.networkInfoList(), other.networkInfoList()) && Objects.equals(this.osInfo(), other.osInfo());
    }

    public final String toString() {
        return ToString.builder((String)"SystemInfo").add("CpuArchitecture", (Object)this.cpuArchitecture()).add("FileSystemType", (Object)this.fileSystemType()).add("NetworkInfoList", this.hasNetworkInfoList() ? this.networkInfoList() : null).add("OsInfo", (Object)this.osInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpuArchitecture": {
                return Optional.ofNullable(clazz.cast(this.cpuArchitecture()));
            }
            case "fileSystemType": {
                return Optional.ofNullable(clazz.cast(this.fileSystemType()));
            }
            case "networkInfoList": {
                return Optional.ofNullable(clazz.cast(this.networkInfoList()));
            }
            case "osInfo": {
                return Optional.ofNullable(clazz.cast(this.osInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemInfo, T> g) {
        return obj -> g.apply((SystemInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cpuArchitecture;
        private String fileSystemType;
        private List<NetworkInfo> networkInfoList = DefaultSdkAutoConstructList.getInstance();
        private OSInfo osInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemInfo model) {
            this.cpuArchitecture(model.cpuArchitecture);
            this.fileSystemType(model.fileSystemType);
            this.networkInfoList(model.networkInfoList);
            this.osInfo(model.osInfo);
        }

        public final String getCpuArchitecture() {
            return this.cpuArchitecture;
        }

        public final void setCpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
        }

        @Override
        @Transient
        public final Builder cpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            return this;
        }

        public final String getFileSystemType() {
            return this.fileSystemType;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        @Override
        @Transient
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        public final List<NetworkInfo.Builder> getNetworkInfoList() {
            List<NetworkInfo.Builder> result = NetworkInfoListCopier.copyToBuilder(this.networkInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInfoList(Collection<NetworkInfo.BuilderImpl> networkInfoList) {
            this.networkInfoList = NetworkInfoListCopier.copyFromBuilder(networkInfoList);
        }

        @Override
        @Transient
        public final Builder networkInfoList(Collection<NetworkInfo> networkInfoList) {
            this.networkInfoList = NetworkInfoListCopier.copy(networkInfoList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInfoList(NetworkInfo ... networkInfoList) {
            this.networkInfoList(Arrays.asList(networkInfoList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInfoList(Consumer<NetworkInfo.Builder> ... networkInfoList) {
            this.networkInfoList(Stream.of(networkInfoList).map(c -> (NetworkInfo)((NetworkInfo.Builder)NetworkInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OSInfo.Builder getOsInfo() {
            return this.osInfo != null ? this.osInfo.toBuilder() : null;
        }

        public final void setOsInfo(OSInfo.BuilderImpl osInfo) {
            this.osInfo = osInfo != null ? osInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder osInfo(OSInfo osInfo) {
            this.osInfo = osInfo;
            return this;
        }

        public SystemInfo build() {
            return new SystemInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemInfo> {
        public Builder cpuArchitecture(String var1);

        public Builder fileSystemType(String var1);

        public Builder networkInfoList(Collection<NetworkInfo> var1);

        public Builder networkInfoList(NetworkInfo ... var1);

        public Builder networkInfoList(Consumer<NetworkInfo.Builder> ... var1);

        public Builder osInfo(OSInfo var1);

        default public Builder osInfo(Consumer<OSInfo.Builder> osInfo) {
            return this.osInfo((OSInfo)((OSInfo.Builder)OSInfo.builder().applyMutation(osInfo)).build());
        }
    }
}

