/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCollectionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCollectionDetails> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(DataCollectionDetails.getter(DataCollectionDetails::completionTime)).setter(DataCollectionDetails.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()}).build();
    private static final SdkField<Integer> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failed").getter(DataCollectionDetails.getter(DataCollectionDetails::failed)).setter(DataCollectionDetails.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()}).build();
    private static final SdkField<Integer> IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inProgress").getter(DataCollectionDetails.getter(DataCollectionDetails::inProgress)).setter(DataCollectionDetails.setter(Builder::inProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgress").build()}).build();
    private static final SdkField<Integer> SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("servers").getter(DataCollectionDetails.getter(DataCollectionDetails::servers)).setter(DataCollectionDetails.setter(Builder::servers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servers").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(DataCollectionDetails.getter(DataCollectionDetails::startTime)).setter(DataCollectionDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataCollectionDetails.getter(DataCollectionDetails::statusAsString)).setter(DataCollectionDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> SUCCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("success").getter(DataCollectionDetails.getter(DataCollectionDetails::success)).setter(DataCollectionDetails.setter(Builder::success)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("success").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, FAILED_FIELD, IN_PROGRESS_FIELD, SERVERS_FIELD, START_TIME_FIELD, STATUS_FIELD, SUCCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant completionTime;
    private final Integer failed;
    private final Integer inProgress;
    private final Integer servers;
    private final Instant startTime;
    private final String status;
    private final Integer success;

    private DataCollectionDetails(BuilderImpl builder) {
        this.completionTime = builder.completionTime;
        this.failed = builder.failed;
        this.inProgress = builder.inProgress;
        this.servers = builder.servers;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.success = builder.success;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Integer failed() {
        return this.failed;
    }

    public final Integer inProgress() {
        return this.inProgress;
    }

    public final Integer servers() {
        return this.servers;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final AssessmentStatus status() {
        return AssessmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer success() {
        return this.success;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.servers());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.success());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCollectionDetails)) {
            return false;
        }
        DataCollectionDetails other = (DataCollectionDetails)obj;
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.failed(), other.failed()) && Objects.equals(this.inProgress(), other.inProgress()) && Objects.equals(this.servers(), other.servers()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.success(), other.success());
    }

    public final String toString() {
        return ToString.builder((String)"DataCollectionDetails").add("CompletionTime", (Object)this.completionTime()).add("Failed", (Object)this.failed()).add("InProgress", (Object)this.inProgress()).add("Servers", (Object)this.servers()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("Success", (Object)this.success()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "inProgress": {
                return Optional.ofNullable(clazz.cast(this.inProgress()));
            }
            case "servers": {
                return Optional.ofNullable(clazz.cast(this.servers()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "success": {
                return Optional.ofNullable(clazz.cast(this.success()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCollectionDetails, T> g) {
        return obj -> g.apply((DataCollectionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant completionTime;
        private Integer failed;
        private Integer inProgress;
        private Integer servers;
        private Instant startTime;
        private String status;
        private Integer success;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCollectionDetails model) {
            this.completionTime(model.completionTime);
            this.failed(model.failed);
            this.inProgress(model.inProgress);
            this.servers(model.servers);
            this.startTime(model.startTime);
            this.status(model.status);
            this.success(model.success);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        @Transient
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Integer getFailed() {
            return this.failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        @Transient
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getInProgress() {
            return this.inProgress;
        }

        public final void setInProgress(Integer inProgress) {
            this.inProgress = inProgress;
        }

        @Override
        @Transient
        public final Builder inProgress(Integer inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final Integer getServers() {
            return this.servers;
        }

        public final void setServers(Integer servers) {
            this.servers = servers;
        }

        @Override
        @Transient
        public final Builder servers(Integer servers) {
            this.servers = servers;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AssessmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getSuccess() {
            return this.success;
        }

        public final void setSuccess(Integer success) {
            this.success = success;
        }

        @Override
        @Transient
        public final Builder success(Integer success) {
            this.success = success;
            return this;
        }

        public DataCollectionDetails build() {
            return new DataCollectionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCollectionDetails> {
        public Builder completionTime(Instant var1);

        public Builder failed(Integer var1);

        public Builder inProgress(Integer var1);

        public Builder servers(Integer var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AssessmentStatus var1);

        public Builder success(Integer var1);
    }
}

