/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceEndpointType {
    LAMBDA("LAMBDA"),
    URL("URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceEndpointType> VALUE_MAP;
    private final String value;

    private ServiceEndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceEndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceEndpointType> knownValues() {
        EnumSet<ServiceEndpointType> knownValues = EnumSet.allOf(ServiceEndpointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceEndpointType.class, ServiceEndpointType::toString);
    }
}

