/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.AdditionalDetailsCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ErrorResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ErrorResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ErrorResponse.getter(ErrorResponse::accountId)).setter(ErrorResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalDetails").getter(ErrorResponse.getter(ErrorResponse::additionalDetails)).setter(ErrorResponse.setter(Builder::additionalDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(ErrorResponse.getter(ErrorResponse::codeAsString)).setter(ErrorResponse.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ErrorResponse.getter(ErrorResponse::message)).setter(ErrorResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(ErrorResponse.getter(ErrorResponse::resourceIdentifier)).setter(ErrorResponse.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ErrorResponse.getter(ErrorResponse::resourceTypeAsString)).setter(ErrorResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ADDITIONAL_DETAILS_FIELD, CODE_FIELD, MESSAGE_FIELD, RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ErrorResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Map<String, String> additionalDetails;
    private final String code;
    private final String message;
    private final String resourceIdentifier;
    private final String resourceType;

    private ErrorResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.additionalDetails = builder.additionalDetails;
        this.code = builder.code;
        this.message = builder.message;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceType = builder.resourceType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasAdditionalDetails() {
        return this.additionalDetails != null && !(this.additionalDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalDetails() {
        return this.additionalDetails;
    }

    public final ErrorCode code() {
        return ErrorCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final String message() {
        return this.message;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final ErrorResourceType resourceType() {
        return ErrorResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDetails() ? this.additionalDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)obj;
        return Objects.equals(this.accountId(), other.accountId()) && this.hasAdditionalDetails() == other.hasAdditionalDetails() && Objects.equals(this.additionalDetails(), other.additionalDetails()) && Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ErrorResponse").add("AccountId", (Object)this.accountId()).add("AdditionalDetails", this.hasAdditionalDetails() ? this.additionalDetails() : null).add("Code", (Object)this.codeAsString()).add("Message", (Object)this.message()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AdditionalDetails": {
                return Optional.ofNullable(clazz.cast(this.additionalDetails()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AdditionalDetails", ADDITIONAL_DETAILS_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorResponse, T> g) {
        return obj -> g.apply((ErrorResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Map<String, String> additionalDetails = DefaultSdkAutoConstructMap.getInstance();
        private String code;
        private String message;
        private String resourceIdentifier;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorResponse model) {
            this.accountId(model.accountId);
            this.additionalDetails(model.additionalDetails);
            this.code(model.code);
            this.message(model.message);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceType(model.resourceType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Map<String, String> getAdditionalDetails() {
            if (this.additionalDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalDetails;
        }

        public final void setAdditionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = AdditionalDetailsCopier.copy(additionalDetails);
        }

        @Override
        public final Builder additionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = AdditionalDetailsCopier.copy(additionalDetails);
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ErrorResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public ErrorResponse build() {
            return new ErrorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ErrorResponse> {
        public Builder accountId(String var1);

        public Builder additionalDetails(Map<String, String> var1);

        public Builder code(String var1);

        public Builder code(ErrorCode var1);

        public Builder message(String var1);

        public Builder resourceIdentifier(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ErrorResourceType var1);
    }
}

