/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProxyType {
    API_GATEWAY("API_GATEWAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProxyType> VALUE_MAP;
    private final String value;

    private ProxyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProxyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProxyType> knownValues() {
        EnumSet<ProxyType> knownValues = EnumSet.allOf(ProxyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProxyType.class, ProxyType::toString);
    }
}

