/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubrefactorspaces.MigrationHubRefactorSpacesAsyncClient;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse;

public class ListEnvironmentVpcsPublisher
implements SdkPublisher<ListEnvironmentVpcsResponse> {
    private final MigrationHubRefactorSpacesAsyncClient client;
    private final ListEnvironmentVpcsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentVpcsPublisher(MigrationHubRefactorSpacesAsyncClient client, ListEnvironmentVpcsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentVpcsPublisher(MigrationHubRefactorSpacesAsyncClient client, ListEnvironmentVpcsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentVpcsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentVpcsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentVpc> environmentVpcList() {
        Function<ListEnvironmentVpcsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentVpcList() != null) {
                return response.environmentVpcList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentVpcsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentVpcsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentVpcsResponse> {
        private ListEnvironmentVpcsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentVpcsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentVpcsResponse> nextPage(ListEnvironmentVpcsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentVpcsPublisher.this.client.listEnvironmentVpcs(ListEnvironmentVpcsPublisher.this.firstRequest);
            }
            return ListEnvironmentVpcsPublisher.this.client.listEnvironmentVpcs((ListEnvironmentVpcsRequest)((Object)ListEnvironmentVpcsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

