/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpcsCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentVpcsResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, ListEnvironmentVpcsResponse> {
    private static final SdkField<List<EnvironmentVpc>> ENVIRONMENT_VPC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentVpcList").getter(ListEnvironmentVpcsResponse.getter(ListEnvironmentVpcsResponse::environmentVpcList)).setter(ListEnvironmentVpcsResponse.setter(Builder::environmentVpcList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVpcList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentVpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEnvironmentVpcsResponse.getter(ListEnvironmentVpcsResponse::nextToken)).setter(ListEnvironmentVpcsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_VPC_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<EnvironmentVpc> environmentVpcList;
    private final String nextToken;

    private ListEnvironmentVpcsResponse(BuilderImpl builder) {
        super(builder);
        this.environmentVpcList = builder.environmentVpcList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEnvironmentVpcList() {
        return this.environmentVpcList != null && !(this.environmentVpcList instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentVpc> environmentVpcList() {
        return this.environmentVpcList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVpcList() ? this.environmentVpcList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentVpcsResponse)) {
            return false;
        }
        ListEnvironmentVpcsResponse other = (ListEnvironmentVpcsResponse)((Object)obj);
        return this.hasEnvironmentVpcList() == other.hasEnvironmentVpcList() && Objects.equals(this.environmentVpcList(), other.environmentVpcList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentVpcsResponse").add("EnvironmentVpcList", this.hasEnvironmentVpcList() ? this.environmentVpcList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentVpcList": {
                return Optional.ofNullable(clazz.cast(this.environmentVpcList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentVpcsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentVpcsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentVpc> environmentVpcList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentVpcsResponse model) {
            super(model);
            this.environmentVpcList(model.environmentVpcList);
            this.nextToken(model.nextToken);
        }

        public final List<EnvironmentVpc.Builder> getEnvironmentVpcList() {
            List<EnvironmentVpc.Builder> result = EnvironmentVpcsCopier.copyToBuilder(this.environmentVpcList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVpcList(Collection<EnvironmentVpc.BuilderImpl> environmentVpcList) {
            this.environmentVpcList = EnvironmentVpcsCopier.copyFromBuilder(environmentVpcList);
        }

        @Override
        public final Builder environmentVpcList(Collection<EnvironmentVpc> environmentVpcList) {
            this.environmentVpcList = EnvironmentVpcsCopier.copy(environmentVpcList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVpcList(EnvironmentVpc ... environmentVpcList) {
            this.environmentVpcList(Arrays.asList(environmentVpcList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVpcList(Consumer<EnvironmentVpc.Builder> ... environmentVpcList) {
            this.environmentVpcList(Stream.of(environmentVpcList).map(c -> (EnvironmentVpc)((EnvironmentVpc.Builder)EnvironmentVpc.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnvironmentVpcsResponse build() {
            return new ListEnvironmentVpcsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentVpcsResponse> {
        public Builder environmentVpcList(Collection<EnvironmentVpc> var1);

        public Builder environmentVpcList(EnvironmentVpc ... var1);

        public Builder environmentVpcList(Consumer<EnvironmentVpc.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

