/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHomeRegionControlResponse extends MigrationHubConfigResponse implements
        ToCopyableBuilder<CreateHomeRegionControlResponse.Builder, CreateHomeRegionControlResponse> {
    private static final SdkField<HomeRegionControl> HOME_REGION_CONTROL_FIELD = SdkField
            .<HomeRegionControl> builder(MarshallingType.SDK_POJO).memberName("HomeRegionControl")
            .getter(getter(CreateHomeRegionControlResponse::homeRegionControl)).setter(setter(Builder::homeRegionControl))
            .constructor(HomeRegionControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegionControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_REGION_CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final HomeRegionControl homeRegionControl;

    private CreateHomeRegionControlResponse(BuilderImpl builder) {
        super(builder);
        this.homeRegionControl = builder.homeRegionControl;
    }

    /**
     * <p>
     * This object is the <code>HomeRegionControl</code> object that's returned by a successful call to
     * <code>CreateHomeRegionControl</code>.
     * </p>
     * 
     * @return This object is the <code>HomeRegionControl</code> object that's returned by a successful call to
     *         <code>CreateHomeRegionControl</code>.
     */
    public final HomeRegionControl homeRegionControl() {
        return homeRegionControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(homeRegionControl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHomeRegionControlResponse)) {
            return false;
        }
        CreateHomeRegionControlResponse other = (CreateHomeRegionControlResponse) obj;
        return Objects.equals(homeRegionControl(), other.homeRegionControl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHomeRegionControlResponse").add("HomeRegionControl", homeRegionControl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HomeRegionControl":
            return Optional.ofNullable(clazz.cast(homeRegionControl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HomeRegionControl", HOME_REGION_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHomeRegionControlResponse, T> g) {
        return obj -> g.apply((CreateHomeRegionControlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHomeRegionControlResponse> {
        /**
         * <p>
         * This object is the <code>HomeRegionControl</code> object that's returned by a successful call to
         * <code>CreateHomeRegionControl</code>.
         * </p>
         * 
         * @param homeRegionControl
         *        This object is the <code>HomeRegionControl</code> object that's returned by a successful call to
         *        <code>CreateHomeRegionControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegionControl(HomeRegionControl homeRegionControl);

        /**
         * <p>
         * This object is the <code>HomeRegionControl</code> object that's returned by a successful call to
         * <code>CreateHomeRegionControl</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HomeRegionControl.Builder} avoiding the
         * need to create one manually via {@link HomeRegionControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HomeRegionControl.Builder#build()} is called immediately and its
         * result is passed to {@link #homeRegionControl(HomeRegionControl)}.
         * 
         * @param homeRegionControl
         *        a consumer that will call methods on {@link HomeRegionControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #homeRegionControl(HomeRegionControl)
         */
        default Builder homeRegionControl(Consumer<HomeRegionControl.Builder> homeRegionControl) {
            return homeRegionControl(HomeRegionControl.builder().applyMutation(homeRegionControl).build());
        }
    }

    static final class BuilderImpl extends MigrationHubConfigResponse.BuilderImpl implements Builder {
        private HomeRegionControl homeRegionControl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHomeRegionControlResponse model) {
            super(model);
            homeRegionControl(model.homeRegionControl);
        }

        public final HomeRegionControl.Builder getHomeRegionControl() {
            return homeRegionControl != null ? homeRegionControl.toBuilder() : null;
        }

        public final void setHomeRegionControl(HomeRegionControl.BuilderImpl homeRegionControl) {
            this.homeRegionControl = homeRegionControl != null ? homeRegionControl.build() : null;
        }

        @Override
        public final Builder homeRegionControl(HomeRegionControl homeRegionControl) {
            this.homeRegionControl = homeRegionControl;
            return this;
        }

        @Override
        public CreateHomeRegionControlResponse build() {
            return new CreateHomeRegionControlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
