/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubconfig.model.MigrationHubConfigRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.Target;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHomeRegionControlsRequest
extends MigrationHubConfigRequest
implements ToCopyableBuilder<Builder, DescribeHomeRegionControlsRequest> {
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlId").getter(DescribeHomeRegionControlsRequest.getter(DescribeHomeRegionControlsRequest::controlId)).setter(DescribeHomeRegionControlsRequest.setter(Builder::controlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlId").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(DescribeHomeRegionControlsRequest.getter(DescribeHomeRegionControlsRequest::homeRegion)).setter(DescribeHomeRegionControlsRequest.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<Target> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Target").getter(DescribeHomeRegionControlsRequest.getter(DescribeHomeRegionControlsRequest::target)).setter(DescribeHomeRegionControlsRequest.setter(Builder::target)).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeHomeRegionControlsRequest.getter(DescribeHomeRegionControlsRequest::maxResults)).setter(DescribeHomeRegionControlsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeHomeRegionControlsRequest.getter(DescribeHomeRegionControlsRequest::nextToken)).setter(DescribeHomeRegionControlsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ID_FIELD, HOME_REGION_FIELD, TARGET_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String controlId;
    private final String homeRegion;
    private final Target target;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeHomeRegionControlsRequest(BuilderImpl builder) {
        super(builder);
        this.controlId = builder.controlId;
        this.homeRegion = builder.homeRegion;
        this.target = builder.target;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String controlId() {
        return this.controlId;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final Target target() {
        return this.target;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.controlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHomeRegionControlsRequest)) {
            return false;
        }
        DescribeHomeRegionControlsRequest other = (DescribeHomeRegionControlsRequest)((Object)obj);
        return Objects.equals(this.controlId(), other.controlId()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHomeRegionControlsRequest").add("ControlId", (Object)this.controlId()).add("HomeRegion", (Object)this.homeRegion()).add("Target", (Object)this.target()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlId": {
                return Optional.ofNullable(clazz.cast(this.controlId()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHomeRegionControlsRequest, T> g) {
        return obj -> g.apply((DescribeHomeRegionControlsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubConfigRequest.BuilderImpl
    implements Builder {
        private String controlId;
        private String homeRegion;
        private Target target;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHomeRegionControlsRequest model) {
            super(model);
            this.controlId(model.controlId);
            this.homeRegion(model.homeRegion);
            this.target(model.target);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getControlId() {
            return this.controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final Target.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHomeRegionControlsRequest build() {
            return new DescribeHomeRegionControlsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHomeRegionControlsRequest> {
        public Builder controlId(String var1);

        public Builder homeRegion(String var1);

        public Builder target(Target var1);

        default public Builder target(Consumer<Target.Builder> target) {
            return this.target((Target)((Target.Builder)Target.builder().applyMutation(target)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

