/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TargetType {
    ACCOUNT("ACCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TargetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetType> knownValues() {
        return Stream.of(TargetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

