/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhub.model.ApplicationStatus;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationStateResponse
extends MigrationHubResponse
implements ToCopyableBuilder<Builder, DescribeApplicationStateResponse> {
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeApplicationStateResponse.getter(DescribeApplicationStateResponse::applicationStatusAsString)).setter(DescribeApplicationStateResponse.setter(Builder::applicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeApplicationStateResponse.getter(DescribeApplicationStateResponse::lastUpdatedTime)).setter(DescribeApplicationStateResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_STATUS_FIELD, LAST_UPDATED_TIME_FIELD));
    private final String applicationStatus;
    private final Instant lastUpdatedTime;

    private DescribeApplicationStateResponse(BuilderImpl builder) {
        super(builder);
        this.applicationStatus = builder.applicationStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationStateResponse)) {
            return false;
        }
        DescribeApplicationStateResponse other = (DescribeApplicationStateResponse)((Object)obj);
        return Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeApplicationStateResponse").add("ApplicationStatus", (Object)this.applicationStatusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationStateResponse, T> g) {
        return obj -> g.apply((DescribeApplicationStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubResponse.BuilderImpl
    implements Builder {
        private String applicationStatus;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationStateResponse model) {
            super(model);
            this.applicationStatus(model.applicationStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getApplicationStatusAsString() {
            return this.applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public DescribeApplicationStateResponse build() {
            return new DescribeApplicationStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationStateResponse> {
        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

