/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhub.model.DiscoveredResource;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateDiscoveredResourceRequest
extends MigrationHubRequest
implements ToCopyableBuilder<Builder, AssociateDiscoveredResourceRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateDiscoveredResourceRequest.getter(AssociateDiscoveredResourceRequest::progressUpdateStream)).setter(AssociateDiscoveredResourceRequest.setter(Builder::progressUpdateStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build()}).build();
    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateDiscoveredResourceRequest.getter(AssociateDiscoveredResourceRequest::migrationTaskName)).setter(AssociateDiscoveredResourceRequest.setter(Builder::migrationTaskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()}).build();
    private static final SdkField<DiscoveredResource> DISCOVERED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AssociateDiscoveredResourceRequest.getter(AssociateDiscoveredResourceRequest::discoveredResource)).setter(AssociateDiscoveredResourceRequest.setter(Builder::discoveredResource)).constructor(DiscoveredResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveredResource").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AssociateDiscoveredResourceRequest.getter(AssociateDiscoveredResourceRequest::dryRun)).setter(AssociateDiscoveredResourceRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD, MIGRATION_TASK_NAME_FIELD, DISCOVERED_RESOURCE_FIELD, DRY_RUN_FIELD));
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final DiscoveredResource discoveredResource;
    private final Boolean dryRun;

    private AssociateDiscoveredResourceRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.discoveredResource = builder.discoveredResource;
        this.dryRun = builder.dryRun;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public DiscoveredResource discoveredResource() {
        return this.discoveredResource;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveredResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDiscoveredResourceRequest)) {
            return false;
        }
        AssociateDiscoveredResourceRequest other = (AssociateDiscoveredResourceRequest)((Object)obj);
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.discoveredResource(), other.discoveredResource()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"AssociateDiscoveredResourceRequest").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("DiscoveredResource", (Object)this.discoveredResource()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.ofNullable(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskName()));
            }
            case "DiscoveredResource": {
                return Optional.ofNullable(clazz.cast(this.discoveredResource()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateDiscoveredResourceRequest, T> g) {
        return obj -> g.apply((AssociateDiscoveredResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRequest.BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private DiscoveredResource discoveredResource;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDiscoveredResourceRequest model) {
            super(model);
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.discoveredResource(model.discoveredResource);
            this.dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final DiscoveredResource.Builder getDiscoveredResource() {
            return this.discoveredResource != null ? this.discoveredResource.toBuilder() : null;
        }

        @Override
        public final Builder discoveredResource(DiscoveredResource discoveredResource) {
            this.discoveredResource = discoveredResource;
            return this;
        }

        public final void setDiscoveredResource(DiscoveredResource.BuilderImpl discoveredResource) {
            this.discoveredResource = discoveredResource != null ? discoveredResource.build() : null;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDiscoveredResourceRequest build() {
            return new AssociateDiscoveredResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateDiscoveredResourceRequest> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder discoveredResource(DiscoveredResource var1);

        default public Builder discoveredResource(Consumer<DiscoveredResource.Builder> discoveredResource) {
            return this.discoveredResource((DiscoveredResource)((DiscoveredResource.Builder)DiscoveredResource.builder().applyMutation(discoveredResource)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

