/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMigrationTaskUpdatesResponse extends MigrationHubResponse implements
        ToCopyableBuilder<ListMigrationTaskUpdatesResponse.Builder, ListMigrationTaskUpdatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMigrationTaskUpdatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MigrationTaskUpdate>> MIGRATION_TASK_UPDATE_LIST_FIELD = SdkField
            .<List<MigrationTaskUpdate>> builder(MarshallingType.LIST)
            .memberName("MigrationTaskUpdateList")
            .getter(getter(ListMigrationTaskUpdatesResponse::migrationTaskUpdateList))
            .setter(setter(Builder::migrationTaskUpdateList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskUpdateList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MigrationTaskUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(MigrationTaskUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MIGRATION_TASK_UPDATE_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<MigrationTaskUpdate> migrationTaskUpdateList;

    private ListMigrationTaskUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.migrationTaskUpdateList = builder.migrationTaskUpdateList;
    }

    /**
     * <p>
     * If the response includes a <code>NextToken</code> value, that means that there are more results available. The
     * value of <code>NextToken</code> is a unique pagination token for each page. To retrieve the next page of results,
     * call this API again and specify this <code>NextToken</code> value in the request. Keep all other arguments
     * unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP
     * 400 InvalidToken error.
     * </p>
     * 
     * @return If the response includes a <code>NextToken</code> value, that means that there are more results
     *         available. The value of <code>NextToken</code> is a unique pagination token for each page. To retrieve
     *         the next page of results, call this API again and specify this <code>NextToken</code> value in the
     *         request. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an
     *         expired pagination token will return an HTTP 400 InvalidToken error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MigrationTaskUpdateList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMigrationTaskUpdateList() {
        return migrationTaskUpdateList != null && !(migrationTaskUpdateList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of migration-task updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMigrationTaskUpdateList} method.
     * </p>
     * 
     * @return The list of migration-task updates.
     */
    public final List<MigrationTaskUpdate> migrationTaskUpdateList() {
        return migrationTaskUpdateList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMigrationTaskUpdateList() ? migrationTaskUpdateList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMigrationTaskUpdatesResponse)) {
            return false;
        }
        ListMigrationTaskUpdatesResponse other = (ListMigrationTaskUpdatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasMigrationTaskUpdateList() == other.hasMigrationTaskUpdateList()
                && Objects.equals(migrationTaskUpdateList(), other.migrationTaskUpdateList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMigrationTaskUpdatesResponse").add("NextToken", nextToken())
                .add("MigrationTaskUpdateList", hasMigrationTaskUpdateList() ? migrationTaskUpdateList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MigrationTaskUpdateList":
            return Optional.ofNullable(clazz.cast(migrationTaskUpdateList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MigrationTaskUpdateList", MIGRATION_TASK_UPDATE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMigrationTaskUpdatesResponse, T> g) {
        return obj -> g.apply((ListMigrationTaskUpdatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMigrationTaskUpdatesResponse> {
        /**
         * <p>
         * If the response includes a <code>NextToken</code> value, that means that there are more results available.
         * The value of <code>NextToken</code> is a unique pagination token for each page. To retrieve the next page of
         * results, call this API again and specify this <code>NextToken</code> value in the request. Keep all other
         * arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will
         * return an HTTP 400 InvalidToken error.
         * </p>
         * 
         * @param nextToken
         *        If the response includes a <code>NextToken</code> value, that means that there are more results
         *        available. The value of <code>NextToken</code> is a unique pagination token for each page. To retrieve
         *        the next page of results, call this API again and specify this <code>NextToken</code> value in the
         *        request. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an
         *        expired pagination token will return an HTTP 400 InvalidToken error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of migration-task updates.
         * </p>
         * 
         * @param migrationTaskUpdateList
         *        The list of migration-task updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskUpdateList(Collection<MigrationTaskUpdate> migrationTaskUpdateList);

        /**
         * <p>
         * The list of migration-task updates.
         * </p>
         * 
         * @param migrationTaskUpdateList
         *        The list of migration-task updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskUpdateList(MigrationTaskUpdate... migrationTaskUpdateList);

        /**
         * <p>
         * The list of migration-task updates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdate.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #migrationTaskUpdateList(List<MigrationTaskUpdate>)}.
         * 
         * @param migrationTaskUpdateList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationTaskUpdateList(java.util.Collection<MigrationTaskUpdate>)
         */
        Builder migrationTaskUpdateList(Consumer<MigrationTaskUpdate.Builder>... migrationTaskUpdateList);
    }

    static final class BuilderImpl extends MigrationHubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MigrationTaskUpdate> migrationTaskUpdateList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMigrationTaskUpdatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            migrationTaskUpdateList(model.migrationTaskUpdateList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MigrationTaskUpdate.Builder> getMigrationTaskUpdateList() {
            List<MigrationTaskUpdate.Builder> result = MigrationTaskUpdateListCopier.copyToBuilder(this.migrationTaskUpdateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMigrationTaskUpdateList(Collection<MigrationTaskUpdate.BuilderImpl> migrationTaskUpdateList) {
            this.migrationTaskUpdateList = MigrationTaskUpdateListCopier.copyFromBuilder(migrationTaskUpdateList);
        }

        @Override
        public final Builder migrationTaskUpdateList(Collection<MigrationTaskUpdate> migrationTaskUpdateList) {
            this.migrationTaskUpdateList = MigrationTaskUpdateListCopier.copy(migrationTaskUpdateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskUpdateList(MigrationTaskUpdate... migrationTaskUpdateList) {
            migrationTaskUpdateList(Arrays.asList(migrationTaskUpdateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskUpdateList(Consumer<MigrationTaskUpdate.Builder>... migrationTaskUpdateList) {
            migrationTaskUpdateList(Stream.of(migrationTaskUpdateList)
                    .map(c -> MigrationTaskUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMigrationTaskUpdatesResponse build() {
            return new ListMigrationTaskUpdatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
