/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.ApplicationState;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse;

public class ListApplicationStatesIterable
implements SdkIterable<ListApplicationStatesResponse> {
    private final MigrationHubClient client;
    private final ListApplicationStatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationStatesIterable(MigrationHubClient client, ListApplicationStatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationStatesResponseFetcher();
    }

    public Iterator<ListApplicationStatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationState> applicationStateList() {
        Function<ListApplicationStatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationStateList() != null) {
                return response.applicationStateList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationStatesResponseFetcher
    implements SyncPageFetcher<ListApplicationStatesResponse> {
        private ListApplicationStatesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationStatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationStatesResponse nextPage(ListApplicationStatesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationStatesIterable.this.client.listApplicationStates(ListApplicationStatesIterable.this.firstRequest);
            }
            return ListApplicationStatesIterable.this.client.listApplicationStates((ListApplicationStatesRequest)((Object)ListApplicationStatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

