/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTaskUpdatesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTaskUpdatesResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdate;

public class ListMigrationTaskUpdatesIterable
implements SdkIterable<ListMigrationTaskUpdatesResponse> {
    private final MigrationHubClient client;
    private final ListMigrationTaskUpdatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMigrationTaskUpdatesIterable(MigrationHubClient client, ListMigrationTaskUpdatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMigrationTaskUpdatesResponseFetcher();
    }

    public Iterator<ListMigrationTaskUpdatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MigrationTaskUpdate> migrationTaskUpdateList() {
        Function<ListMigrationTaskUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.migrationTaskUpdateList() != null) {
                return response.migrationTaskUpdateList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMigrationTaskUpdatesResponseFetcher
    implements SyncPageFetcher<ListMigrationTaskUpdatesResponse> {
        private ListMigrationTaskUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(ListMigrationTaskUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMigrationTaskUpdatesResponse nextPage(ListMigrationTaskUpdatesResponse previousPage) {
            if (previousPage == null) {
                return ListMigrationTaskUpdatesIterable.this.client.listMigrationTaskUpdates(ListMigrationTaskUpdatesIterable.this.firstRequest);
            }
            return ListMigrationTaskUpdatesIterable.this.client.listMigrationTaskUpdates((ListMigrationTaskUpdatesRequest)((Object)ListMigrationTaskUpdatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

