/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhub.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrationTaskSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MigrationTaskSummary> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgressUpdateStream").getter(MigrationTaskSummary.getter(MigrationTaskSummary::progressUpdateStream)).setter(MigrationTaskSummary.setter(Builder::progressUpdateStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build()}).build();
    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationTaskName").getter(MigrationTaskSummary.getter(MigrationTaskSummary::migrationTaskName)).setter(MigrationTaskSummary.setter(Builder::migrationTaskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MigrationTaskSummary.getter(MigrationTaskSummary::statusAsString)).setter(MigrationTaskSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgressPercent").getter(MigrationTaskSummary.getter(MigrationTaskSummary::progressPercent)).setter(MigrationTaskSummary.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()}).build();
    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetail").getter(MigrationTaskSummary.getter(MigrationTaskSummary::statusDetail)).setter(MigrationTaskSummary.setter(Builder::statusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateDateTime").getter(MigrationTaskSummary.getter(MigrationTaskSummary::updateDateTime)).setter(MigrationTaskSummary.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD, MIGRATION_TASK_NAME_FIELD, STATUS_FIELD, PROGRESS_PERCENT_FIELD, STATUS_DETAIL_FIELD, UPDATE_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProgressUpdateStream", PROGRESS_UPDATE_STREAM_FIELD);
            this.put("MigrationTaskName", MIGRATION_TASK_NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ProgressPercent", PROGRESS_PERCENT_FIELD);
            this.put("StatusDetail", STATUS_DETAIL_FIELD);
            this.put("UpdateDateTime", UPDATE_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final String status;
    private final Integer progressPercent;
    private final String statusDetail;
    private final Instant updateDateTime;

    private MigrationTaskSummary(BuilderImpl builder) {
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.status = builder.status;
        this.progressPercent = builder.progressPercent;
        this.statusDetail = builder.statusDetail;
        this.updateDateTime = builder.updateDateTime;
    }

    public final String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public final String migrationTaskName() {
        return this.migrationTaskName;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer progressPercent() {
        return this.progressPercent;
    }

    public final String statusDetail() {
        return this.statusDetail;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTaskSummary)) {
            return false;
        }
        MigrationTaskSummary other = (MigrationTaskSummary)obj;
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.progressPercent(), other.progressPercent()) && Objects.equals(this.statusDetail(), other.statusDetail()) && Objects.equals(this.updateDateTime(), other.updateDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"MigrationTaskSummary").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("Status", (Object)this.statusAsString()).add("ProgressPercent", (Object)this.progressPercent()).add("StatusDetail", (Object)this.statusDetail()).add("UpdateDateTime", (Object)this.updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.ofNullable(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
            case "StatusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
            case "UpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MigrationTaskSummary, T> g) {
        return obj -> g.apply((MigrationTaskSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private String status;
        private Integer progressPercent;
        private String statusDetail;
        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTaskSummary model) {
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.status(model.status);
            this.progressPercent(model.progressPercent);
            this.statusDetail(model.statusDetail);
            this.updateDateTime(model.updateDateTime);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getProgressPercent() {
            return this.progressPercent;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public MigrationTaskSummary build() {
            return new MigrationTaskSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MigrationTaskSummary> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder progressPercent(Integer var1);

        public Builder statusDetail(String var1);

        public Builder updateDateTime(Instant var1);
    }
}

