/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.MigrationHubServiceClientConfiguration;
import software.amazon.awssdk.services.migrationhub.internal.MigrationHubServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.migrationhub.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.DryRunOperationException;
import software.amazon.awssdk.services.migrationhub.model.HomeRegionNotSetException;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.InternalServerErrorException;
import software.amazon.awssdk.services.migrationhub.model.InvalidInputException;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubException;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateResponse;
import software.amazon.awssdk.services.migrationhub.model.PolicyErrorException;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesResponse;
import software.amazon.awssdk.services.migrationhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.migrationhub.model.ServiceUnavailableException;
import software.amazon.awssdk.services.migrationhub.model.ThrottlingException;
import software.amazon.awssdk.services.migrationhub.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.migrationhub.transform.AssociateCreatedArtifactRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.AssociateDiscoveredResourceRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.CreateProgressUpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DeleteProgressUpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeApplicationStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeMigrationTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateCreatedArtifactRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateDiscoveredResourceRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ImportMigrationTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListApplicationStatesRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListCreatedArtifactsRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListMigrationTasksRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListProgressUpdateStreamsRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyApplicationStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyMigrationTaskStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.PutResourceAttributesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMigrationHubClient
implements MigrationHubClient {
    private static final Logger log = Logger.loggerFor(DefaultMigrationHubClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMigrationHubClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateCreatedArtifactResponse associateCreatedArtifact(AssociateCreatedArtifactRequest associateCreatedArtifactRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateCreatedArtifactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateCreatedArtifactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, associateCreatedArtifactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateCreatedArtifact");
            AssociateCreatedArtifactResponse associateCreatedArtifactResponse = (AssociateCreatedArtifactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateCreatedArtifact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateCreatedArtifactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateCreatedArtifactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateCreatedArtifactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$associateCreatedArtifact$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateDiscoveredResourceResponse associateDiscoveredResource(AssociateDiscoveredResourceRequest associateDiscoveredResourceRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateDiscoveredResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateDiscoveredResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, associateDiscoveredResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateDiscoveredResource");
            AssociateDiscoveredResourceResponse associateDiscoveredResourceResponse = (AssociateDiscoveredResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateDiscoveredResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateDiscoveredResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateDiscoveredResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateDiscoveredResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$associateDiscoveredResource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProgressUpdateStreamResponse createProgressUpdateStream(CreateProgressUpdateStreamRequest createProgressUpdateStreamRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProgressUpdateStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createProgressUpdateStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, createProgressUpdateStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProgressUpdateStream");
            CreateProgressUpdateStreamResponse createProgressUpdateStreamResponse = (CreateProgressUpdateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProgressUpdateStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createProgressUpdateStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProgressUpdateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProgressUpdateStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$createProgressUpdateStream$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProgressUpdateStreamResponse deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest deleteProgressUpdateStreamRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProgressUpdateStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteProgressUpdateStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, deleteProgressUpdateStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProgressUpdateStream");
            DeleteProgressUpdateStreamResponse deleteProgressUpdateStreamResponse = (DeleteProgressUpdateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProgressUpdateStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteProgressUpdateStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProgressUpdateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProgressUpdateStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$deleteProgressUpdateStream$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationStateResponse describeApplicationState(DescribeApplicationStateRequest describeApplicationStateRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, describeApplicationStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationState");
            DescribeApplicationStateResponse describeApplicationStateResponse = (DescribeApplicationStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeApplicationStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$describeApplicationState$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMigrationTaskResponse describeMigrationTask(DescribeMigrationTaskRequest describeMigrationTaskRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMigrationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMigrationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, describeMigrationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMigrationTask");
            DescribeMigrationTaskResponse describeMigrationTaskResponse = (DescribeMigrationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMigrationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMigrationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMigrationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMigrationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$describeMigrationTask$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateCreatedArtifactResponse disassociateCreatedArtifact(DisassociateCreatedArtifactRequest disassociateCreatedArtifactRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateCreatedArtifactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateCreatedArtifactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, disassociateCreatedArtifactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateCreatedArtifact");
            DisassociateCreatedArtifactResponse disassociateCreatedArtifactResponse = (DisassociateCreatedArtifactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateCreatedArtifact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateCreatedArtifactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateCreatedArtifactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateCreatedArtifactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$disassociateCreatedArtifact$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateDiscoveredResourceResponse disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest disassociateDiscoveredResourceRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateDiscoveredResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateDiscoveredResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, disassociateDiscoveredResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateDiscoveredResource");
            DisassociateDiscoveredResourceResponse disassociateDiscoveredResourceResponse = (DisassociateDiscoveredResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateDiscoveredResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateDiscoveredResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateDiscoveredResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateDiscoveredResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$disassociateDiscoveredResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportMigrationTaskResponse importMigrationTask(ImportMigrationTaskRequest importMigrationTaskRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportMigrationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importMigrationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, importMigrationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportMigrationTask");
            ImportMigrationTaskResponse importMigrationTaskResponse = (ImportMigrationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportMigrationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importMigrationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportMigrationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importMigrationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$importMigrationTask$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationStatesResponse listApplicationStates(ListApplicationStatesRequest listApplicationStatesRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationStatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationStatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, listApplicationStatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationStates");
            ListApplicationStatesResponse listApplicationStatesResponse = (ListApplicationStatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationStates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApplicationStatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationStatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationStatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$listApplicationStates$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCreatedArtifactsResponse listCreatedArtifacts(ListCreatedArtifactsRequest listCreatedArtifactsRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCreatedArtifactsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCreatedArtifactsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, listCreatedArtifactsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCreatedArtifacts");
            ListCreatedArtifactsResponse listCreatedArtifactsResponse = (ListCreatedArtifactsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCreatedArtifacts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCreatedArtifactsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCreatedArtifactsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCreatedArtifactsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$listCreatedArtifacts$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDiscoveredResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDiscoveredResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, listDiscoveredResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDiscoveredResources");
            ListDiscoveredResourcesResponse listDiscoveredResourcesResponse = (ListDiscoveredResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDiscoveredResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDiscoveredResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDiscoveredResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDiscoveredResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$listDiscoveredResources$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMigrationTasksResponse listMigrationTasks(ListMigrationTasksRequest listMigrationTasksRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMigrationTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMigrationTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, listMigrationTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMigrationTasks");
            ListMigrationTasksResponse listMigrationTasksResponse = (ListMigrationTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMigrationTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMigrationTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMigrationTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMigrationTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$listMigrationTasks$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProgressUpdateStreamsResponse listProgressUpdateStreams(ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProgressUpdateStreamsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listProgressUpdateStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, listProgressUpdateStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProgressUpdateStreams");
            ListProgressUpdateStreamsResponse listProgressUpdateStreamsResponse = (ListProgressUpdateStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProgressUpdateStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listProgressUpdateStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProgressUpdateStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProgressUpdateStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$listProgressUpdateStreams$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyApplicationStateResponse notifyApplicationState(NotifyApplicationStateRequest notifyApplicationStateRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyApplicationStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)notifyApplicationStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, notifyApplicationStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyApplicationState");
            NotifyApplicationStateResponse notifyApplicationStateResponse = (NotifyApplicationStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyApplicationState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)notifyApplicationStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new NotifyApplicationStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyApplicationStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$notifyApplicationState$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyMigrationTaskStateResponse notifyMigrationTaskState(NotifyMigrationTaskStateRequest notifyMigrationTaskStateRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyMigrationTaskStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)notifyMigrationTaskStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, notifyMigrationTaskStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyMigrationTaskState");
            NotifyMigrationTaskStateResponse notifyMigrationTaskStateResponse = (NotifyMigrationTaskStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyMigrationTaskState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)notifyMigrationTaskStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new NotifyMigrationTaskStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyMigrationTaskStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$notifyMigrationTaskState$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourceAttributesResponse putResourceAttributes(PutResourceAttributesRequest putResourceAttributesRequest) throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourceAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubClient.resolveMetricPublishers(clientConfiguration, putResourceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Migration Hub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourceAttributes");
            PutResourceAttributesResponse putResourceAttributesResponse = (PutResourceAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourceAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourceAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubClient.lambda$putResourceAttributes$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "mgh";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        MigrationHubServiceClientConfigurationBuilder serviceConfigBuilder = new MigrationHubServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MigrationHubException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedOperation").exceptionBuilderSupplier(UnauthorizedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyErrorException").exceptionBuilderSupplier(PolicyErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").exceptionBuilderSupplier(HomeRegionNotSetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DryRunOperation").exceptionBuilderSupplier(DryRunOperationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final MigrationHubServiceClientConfiguration serviceClientConfiguration() {
        return new MigrationHubServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$putResourceAttributes$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyMigrationTaskState$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyApplicationState$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProgressUpdateStreams$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMigrationTasks$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDiscoveredResources$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCreatedArtifacts$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationStates$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importMigrationTask$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateDiscoveredResource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateCreatedArtifact$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMigrationTask$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationState$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProgressUpdateStream$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProgressUpdateStream$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateDiscoveredResource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateCreatedArtifact$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

