/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary;

public class ListMigrationTasksPublisher
implements SdkPublisher<ListMigrationTasksResponse> {
    private final MigrationHubAsyncClient client;
    private final ListMigrationTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMigrationTasksPublisher(MigrationHubAsyncClient client, ListMigrationTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMigrationTasksPublisher(MigrationHubAsyncClient client, ListMigrationTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMigrationTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMigrationTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MigrationTaskSummary> migrationTaskSummaryList() {
        Function<ListMigrationTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.migrationTaskSummaryList() != null) {
                return response.migrationTaskSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMigrationTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMigrationTasksResponseFetcher
    implements AsyncPageFetcher<ListMigrationTasksResponse> {
        private ListMigrationTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListMigrationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMigrationTasksResponse> nextPage(ListMigrationTasksResponse previousPage) {
            if (previousPage == null) {
                return ListMigrationTasksPublisher.this.client.listMigrationTasks(ListMigrationTasksPublisher.this.firstRequest);
            }
            return ListMigrationTasksPublisher.this.client.listMigrationTasks((ListMigrationTasksRequest)((Object)ListMigrationTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

