/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.migrationhub.DefaultMigrationHubBaseClientBuilder;
import software.amazon.awssdk.services.migrationhub.DefaultMigrationHubClient;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.MigrationHubClientBuilder;
import software.amazon.awssdk.services.migrationhub.MigrationHubServiceClientConfiguration;
import software.amazon.awssdk.services.migrationhub.endpoints.MigrationHubEndpointProvider;

@SdkInternalApi
final class DefaultMigrationHubClientBuilder
extends DefaultMigrationHubBaseClientBuilder<MigrationHubClientBuilder, MigrationHubClient>
implements MigrationHubClientBuilder {
    DefaultMigrationHubClientBuilder() {
    }

    @Override
    public DefaultMigrationHubClientBuilder endpointProvider(MigrationHubEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MigrationHubClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMigrationHubClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MigrationHubServiceClientConfiguration serviceClientConfiguration = MigrationHubServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMigrationHubClient(serviceClientConfiguration, clientConfiguration);
    }
}

