/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhub.model.DiscoveredResource;
import software.amazon.awssdk.services.migrationhub.model.DiscoveredResourceListCopier;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDiscoveredResourcesResponse
extends MigrationHubResponse
implements ToCopyableBuilder<Builder, ListDiscoveredResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDiscoveredResourcesResponse.getter(ListDiscoveredResourcesResponse::nextToken)).setter(ListDiscoveredResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<DiscoveredResource>> DISCOVERED_RESOURCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiscoveredResourceList").getter(ListDiscoveredResourcesResponse.getter(ListDiscoveredResourcesResponse::discoveredResourceList)).setter(ListDiscoveredResourcesResponse.setter(Builder::discoveredResourceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveredResourceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiscoveredResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DISCOVERED_RESOURCE_LIST_FIELD));
    private final String nextToken;
    private final List<DiscoveredResource> discoveredResourceList;

    private ListDiscoveredResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.discoveredResourceList = builder.discoveredResourceList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDiscoveredResourceList() {
        return this.discoveredResourceList != null && !(this.discoveredResourceList instanceof SdkAutoConstructList);
    }

    public final List<DiscoveredResource> discoveredResourceList() {
        return this.discoveredResourceList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiscoveredResourceList() ? this.discoveredResourceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesResponse)) {
            return false;
        }
        ListDiscoveredResourcesResponse other = (ListDiscoveredResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDiscoveredResourceList() == other.hasDiscoveredResourceList() && Objects.equals(this.discoveredResourceList(), other.discoveredResourceList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDiscoveredResourcesResponse").add("NextToken", (Object)this.nextToken()).add("DiscoveredResourceList", this.hasDiscoveredResourceList() ? this.discoveredResourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DiscoveredResourceList": {
                return Optional.ofNullable(clazz.cast(this.discoveredResourceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoveredResourcesResponse, T> g) {
        return obj -> g.apply((ListDiscoveredResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DiscoveredResource> discoveredResourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.discoveredResourceList(model.discoveredResourceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DiscoveredResource.Builder> getDiscoveredResourceList() {
            List<DiscoveredResource.Builder> result = DiscoveredResourceListCopier.copyToBuilder(this.discoveredResourceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiscoveredResourceList(Collection<DiscoveredResource.BuilderImpl> discoveredResourceList) {
            this.discoveredResourceList = DiscoveredResourceListCopier.copyFromBuilder(discoveredResourceList);
        }

        @Override
        @Transient
        public final Builder discoveredResourceList(Collection<DiscoveredResource> discoveredResourceList) {
            this.discoveredResourceList = DiscoveredResourceListCopier.copy(discoveredResourceList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder discoveredResourceList(DiscoveredResource ... discoveredResourceList) {
            this.discoveredResourceList(Arrays.asList(discoveredResourceList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder discoveredResourceList(Consumer<DiscoveredResource.Builder> ... discoveredResourceList) {
            this.discoveredResourceList(Stream.of(discoveredResourceList).map(c -> (DiscoveredResource)((DiscoveredResource.Builder)DiscoveredResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDiscoveredResourcesResponse build() {
            return new ListDiscoveredResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDiscoveredResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder discoveredResourceList(Collection<DiscoveredResource> var1);

        public Builder discoveredResourceList(DiscoveredResource ... var1);

        public Builder discoveredResourceList(Consumer<DiscoveredResource.Builder> ... var1);
    }
}

