/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.model.CreatedArtifact;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse;

public class ListCreatedArtifactsIterable
implements SdkIterable<ListCreatedArtifactsResponse> {
    private final MigrationHubClient client;
    private final ListCreatedArtifactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCreatedArtifactsIterable(MigrationHubClient client, ListCreatedArtifactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCreatedArtifactsResponseFetcher();
    }

    public Iterator<ListCreatedArtifactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CreatedArtifact> createdArtifactList() {
        Function<ListCreatedArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.createdArtifactList() != null) {
                return response.createdArtifactList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCreatedArtifactsResponseFetcher
    implements SyncPageFetcher<ListCreatedArtifactsResponse> {
        private ListCreatedArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListCreatedArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCreatedArtifactsResponse nextPage(ListCreatedArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListCreatedArtifactsIterable.this.client.listCreatedArtifacts(ListCreatedArtifactsIterable.this.firstRequest);
            }
            return ListCreatedArtifactsIterable.this.client.listCreatedArtifacts((ListCreatedArtifactsRequest)((Object)ListCreatedArtifactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

