/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary;

public class ListMigrationTasksIterable
implements SdkIterable<ListMigrationTasksResponse> {
    private final MigrationHubClient client;
    private final ListMigrationTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMigrationTasksIterable(MigrationHubClient client, ListMigrationTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMigrationTasksResponseFetcher();
    }

    public Iterator<ListMigrationTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MigrationTaskSummary> migrationTaskSummaryList() {
        Function<ListMigrationTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.migrationTaskSummaryList() != null) {
                return response.migrationTaskSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMigrationTasksResponseFetcher
    implements SyncPageFetcher<ListMigrationTasksResponse> {
        private ListMigrationTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListMigrationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMigrationTasksResponse nextPage(ListMigrationTasksResponse previousPage) {
            if (previousPage == null) {
                return ListMigrationTasksIterable.this.client.listMigrationTasks(ListMigrationTasksIterable.this.firstRequest);
            }
            return ListMigrationTasksIterable.this.client.listMigrationTasks((ListMigrationTasksRequest)((Object)ListMigrationTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

