/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateDiscoveredResourceRequest extends MigrationHubRequest implements
        ToCopyableBuilder<AssociateDiscoveredResourceRequest.Builder, AssociateDiscoveredResourceRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDiscoveredResourceRequest::progressUpdateStream))
            .setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDiscoveredResourceRequest::migrationTaskName)).setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<DiscoveredResource> DISCOVERED_RESOURCE_FIELD = SdkField
            .<DiscoveredResource> builder(MarshallingType.SDK_POJO)
            .getter(getter(AssociateDiscoveredResourceRequest::discoveredResource)).setter(setter(Builder::discoveredResource))
            .constructor(DiscoveredResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveredResource").build())
            .build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssociateDiscoveredResourceRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, DISCOVERED_RESOURCE_FIELD, DRY_RUN_FIELD));

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final DiscoveredResource discoveredResource;

    private final Boolean dryRun;

    private AssociateDiscoveredResourceRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.discoveredResource = builder.discoveredResource;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the ProgressUpdateStream.
     * </p>
     * 
     * @return The name of the ProgressUpdateStream.
     */
    public String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i>
     */
    public String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * Object representing a Resource.
     * </p>
     * 
     * @return Object representing a Resource.
     */
    public DiscoveredResource discoveredResource() {
        return discoveredResource;
    }

    /**
     * <p>
     * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission
     * to make the call.
     * </p>
     * 
     * @return Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
     *         permission to make the call.
     */
    public Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(discoveredResource());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDiscoveredResourceRequest)) {
            return false;
        }
        AssociateDiscoveredResourceRequest other = (AssociateDiscoveredResourceRequest) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(discoveredResource(), other.discoveredResource()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateDiscoveredResourceRequest").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("DiscoveredResource", discoveredResource())
                .add("DryRun", dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "DiscoveredResource":
            return Optional.ofNullable(clazz.cast(discoveredResource()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateDiscoveredResourceRequest, T> g) {
        return obj -> g.apply((AssociateDiscoveredResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateDiscoveredResourceRequest> {
        /**
         * <p>
         * The name of the ProgressUpdateStream.
         * </p>
         * 
         * @param progressUpdateStream
         *        The name of the ProgressUpdateStream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        The identifier given to the MigrationTask. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * Object representing a Resource.
         * </p>
         * 
         * @param discoveredResource
         *        Object representing a Resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveredResource(DiscoveredResource discoveredResource);

        /**
         * <p>
         * Object representing a Resource.
         * </p>
         * This is a convenience that creates an instance of the {@link DiscoveredResource.Builder} avoiding the need to
         * create one manually via {@link DiscoveredResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DiscoveredResource.Builder#build()} is called immediately and its
         * result is passed to {@link #discoveredResource(DiscoveredResource)}.
         * 
         * @param discoveredResource
         *        a consumer that will call methods on {@link DiscoveredResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #discoveredResource(DiscoveredResource)
         */
        default Builder discoveredResource(Consumer<DiscoveredResource.Builder> discoveredResource) {
            return discoveredResource(DiscoveredResource.builder().applyMutation(discoveredResource).build());
        }

        /**
         * <p>
         * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         * permission to make the call.
         * </p>
         * 
         * @param dryRun
         *        Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         *        permission to make the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private DiscoveredResource discoveredResource;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDiscoveredResourceRequest model) {
            super(model);
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            discoveredResource(model.discoveredResource);
            dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final DiscoveredResource.Builder getDiscoveredResource() {
            return discoveredResource != null ? discoveredResource.toBuilder() : null;
        }

        @Override
        public final Builder discoveredResource(DiscoveredResource discoveredResource) {
            this.discoveredResource = discoveredResource;
            return this;
        }

        public final void setDiscoveredResource(DiscoveredResource.BuilderImpl discoveredResource) {
            this.discoveredResource = discoveredResource != null ? discoveredResource.build() : null;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDiscoveredResourceRequest build() {
            return new AssociateDiscoveredResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
