/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of an application discovered through Migration Hub import, the AWS Agentless Discovery Connector, or the
 * AWS Application Discovery Agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationState implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationState.Builder, ApplicationState> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationState::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationState::applicationStatusAsString)).setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ApplicationState::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_STATUS_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String applicationStatus;

    private final Instant lastUpdatedTime;

    private ApplicationState(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationStatus = builder.applicationStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The configurationId from the Application Discovery Service that uniquely identifies an application.
     * </p>
     * 
     * @return The configurationId from the Application Discovery Service that uniquely identifies an application.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The current status of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The current status of an application.
     * @see ApplicationStatus
     */
    public ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * The current status of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return The current status of an application.
     * @see ApplicationStatus
     */
    public String applicationStatusAsString() {
        return applicationStatus;
    }

    /**
     * <p>
     * The timestamp when the application status was last updated.
     * </p>
     * 
     * @return The timestamp when the application status was last updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationState)) {
            return false;
        }
        ApplicationState other = (ApplicationState) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationStatusAsString(), other.applicationStatusAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationState").add("ApplicationId", applicationId())
                .add("ApplicationStatus", applicationStatusAsString()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationState, T> g) {
        return obj -> g.apply((ApplicationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationState> {
        /**
         * <p>
         * The configurationId from the Application Discovery Service that uniquely identifies an application.
         * </p>
         * 
         * @param applicationId
         *        The configurationId from the Application Discovery Service that uniquely identifies an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The current status of an application.
         * </p>
         * 
         * @param applicationStatus
         *        The current status of an application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * The current status of an application.
         * </p>
         * 
         * @param applicationStatus
         *        The current status of an application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);

        /**
         * <p>
         * The timestamp when the application status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the application status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String applicationStatus;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationState model) {
            applicationId(model.applicationId);
            applicationStatus(model.applicationStatus);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public ApplicationState build() {
            return new ApplicationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
