/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoveredResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiscoveredResource> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoveredResource.getter(DiscoveredResource::configurationId)).setter(DiscoveredResource.setter(Builder::configurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoveredResource.getter(DiscoveredResource::description)).setter(DiscoveredResource.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationId;
    private final String description;

    private DiscoveredResource(BuilderImpl builder) {
        this.configurationId = builder.configurationId;
        this.description = builder.description;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveredResource)) {
            return false;
        }
        DiscoveredResource other = (DiscoveredResource)obj;
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"DiscoveredResource").add("ConfigurationId", (Object)this.configurationId()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoveredResource, T> g) {
        return obj -> g.apply((DiscoveredResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveredResource model) {
            this.configurationId(model.configurationId);
            this.description(model.description);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public DiscoveredResource build() {
            return new DiscoveredResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiscoveredResource> {
        public Builder configurationId(String var1);

        public Builder description(String var1);
    }
}

