/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationStatesResponse extends MigrationHubResponse implements
        ToCopyableBuilder<ListApplicationStatesResponse.Builder, ListApplicationStatesResponse> {
    private static final SdkField<List<ApplicationState>> APPLICATION_STATE_LIST_FIELD = SdkField
            .<List<ApplicationState>> builder(MarshallingType.LIST)
            .getter(getter(ListApplicationStatesResponse::applicationStateList))
            .setter(setter(Builder::applicationStateList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStateList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListApplicationStatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_STATE_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ApplicationState> applicationStateList;

    private final String nextToken;

    private ListApplicationStatesResponse(BuilderImpl builder) {
        super(builder);
        this.applicationStateList = builder.applicationStateList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ApplicationStateList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasApplicationStateList() {
        return applicationStateList != null && !(applicationStateList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Applications that exist in Application Discovery Service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApplicationStateList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Applications that exist in Application Discovery Service.
     */
    public List<ApplicationState> applicationStateList() {
        return applicationStateList;
    }

    /**
     * <p>
     * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the
     * next page of results, make the call again using the returned token in <code>NextToken</code>.
     * </p>
     * 
     * @return If a <code>NextToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>
     *         .
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationStateList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationStatesResponse)) {
            return false;
        }
        ListApplicationStatesResponse other = (ListApplicationStatesResponse) obj;
        return Objects.equals(applicationStateList(), other.applicationStateList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListApplicationStatesResponse").add("ApplicationStateList", applicationStateList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationStateList":
            return Optional.ofNullable(clazz.cast(applicationStateList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationStatesResponse, T> g) {
        return obj -> g.apply((ListApplicationStatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationStatesResponse> {
        /**
         * <p>
         * A list of Applications that exist in Application Discovery Service.
         * </p>
         * 
         * @param applicationStateList
         *        A list of Applications that exist in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationStateList(Collection<ApplicationState> applicationStateList);

        /**
         * <p>
         * A list of Applications that exist in Application Discovery Service.
         * </p>
         * 
         * @param applicationStateList
         *        A list of Applications that exist in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationStateList(ApplicationState... applicationStateList);

        /**
         * <p>
         * A list of Applications that exist in Application Discovery Service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApplicationState>.Builder} avoiding the
         * need to create one manually via {@link List<ApplicationState>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationState>.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationStateList(List<ApplicationState>)}.
         * 
         * @param applicationStateList
         *        a consumer that will call methods on {@link List<ApplicationState>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationStateList(List<ApplicationState>)
         */
        Builder applicationStateList(Consumer<ApplicationState.Builder>... applicationStateList);

        /**
         * <p>
         * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve
         * the next page of results, make the call again using the returned token in <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        If a <code>NextToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubResponse.BuilderImpl implements Builder {
        private List<ApplicationState> applicationStateList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationStatesResponse model) {
            super(model);
            applicationStateList(model.applicationStateList);
            nextToken(model.nextToken);
        }

        public final Collection<ApplicationState.Builder> getApplicationStateList() {
            return applicationStateList != null ? applicationStateList.stream().map(ApplicationState::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationStateList(Collection<ApplicationState> applicationStateList) {
            this.applicationStateList = ApplicationStateListCopier.copy(applicationStateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationStateList(ApplicationState... applicationStateList) {
            applicationStateList(Arrays.asList(applicationStateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationStateList(Consumer<ApplicationState.Builder>... applicationStateList) {
            applicationStateList(Stream.of(applicationStateList).map(c -> ApplicationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationStateList(Collection<ApplicationState.BuilderImpl> applicationStateList) {
            this.applicationStateList = ApplicationStateListCopier.copyFromBuilder(applicationStateList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationStatesResponse build() {
            return new ListApplicationStatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
