/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.migrationhub.model.LatestResourceAttributeListCopier;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttribute;
import software.amazon.awssdk.services.migrationhub.model.Task;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrationTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MigrationTask> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MigrationTask.getter(MigrationTask::progressUpdateStream)).setter(MigrationTask.setter(Builder::progressUpdateStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build()}).build();
    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MigrationTask.getter(MigrationTask::migrationTaskName)).setter(MigrationTask.setter(Builder::migrationTaskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()}).build();
    private static final SdkField<Task> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MigrationTask.getter(MigrationTask::task)).setter(MigrationTask.setter(Builder::task)).constructor(Task::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MigrationTask.getter(MigrationTask::updateDateTime)).setter(MigrationTask.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDateTime").build()}).build();
    private static final SdkField<List<ResourceAttribute>> RESOURCE_ATTRIBUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MigrationTask.getter(MigrationTask::resourceAttributeList)).setter(MigrationTask.setter(Builder::resourceAttributeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAttributeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD, MIGRATION_TASK_NAME_FIELD, TASK_FIELD, UPDATE_DATE_TIME_FIELD, RESOURCE_ATTRIBUTE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final Task task;
    private final Instant updateDateTime;
    private final List<ResourceAttribute> resourceAttributeList;

    private MigrationTask(BuilderImpl builder) {
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.task = builder.task;
        this.updateDateTime = builder.updateDateTime;
        this.resourceAttributeList = builder.resourceAttributeList;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public Task task() {
        return this.task;
    }

    public Instant updateDateTime() {
        return this.updateDateTime;
    }

    public List<ResourceAttribute> resourceAttributeList() {
        return this.resourceAttributeList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAttributeList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTask)) {
            return false;
        }
        MigrationTask other = (MigrationTask)obj;
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.resourceAttributeList(), other.resourceAttributeList());
    }

    public String toString() {
        return ToString.builder((String)"MigrationTask").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("Task", (Object)this.task()).add("UpdateDateTime", (Object)this.updateDateTime()).add("ResourceAttributeList", this.resourceAttributeList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.ofNullable(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskName()));
            }
            case "Task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "UpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "ResourceAttributeList": {
                return Optional.ofNullable(clazz.cast(this.resourceAttributeList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrationTask, T> g) {
        return obj -> g.apply((MigrationTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private Task task;
        private Instant updateDateTime;
        private List<ResourceAttribute> resourceAttributeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTask model) {
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.task(model.task);
            this.updateDateTime(model.updateDateTime);
            this.resourceAttributeList(model.resourceAttributeList);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final Task.Builder getTask() {
            return this.task != null ? this.task.toBuilder() : null;
        }

        @Override
        public final Builder task(Task task) {
            this.task = task;
            return this;
        }

        public final void setTask(Task.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        public final Collection<ResourceAttribute.Builder> getResourceAttributeList() {
            return this.resourceAttributeList != null ? (Collection)this.resourceAttributeList.stream().map(ResourceAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList) {
            this.resourceAttributeList = LatestResourceAttributeListCopier.copy(resourceAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(ResourceAttribute ... resourceAttributeList) {
            this.resourceAttributeList(Arrays.asList(resourceAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(Consumer<ResourceAttribute.Builder> ... resourceAttributeList) {
            this.resourceAttributeList(Stream.of(resourceAttributeList).map(c -> (ResourceAttribute)((ResourceAttribute.Builder)ResourceAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAttributeList(Collection<ResourceAttribute.BuilderImpl> resourceAttributeList) {
            this.resourceAttributeList = LatestResourceAttributeListCopier.copyFromBuilder(resourceAttributeList);
        }

        public MigrationTask build() {
            return new MigrationTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MigrationTask> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder task(Task var1);

        default public Builder task(Consumer<Task.Builder> task) {
            return this.task((Task)((Task.Builder)Task.builder().applyMutation(task)).build());
        }

        public Builder updateDateTime(Instant var1);

        public Builder resourceAttributeList(Collection<ResourceAttribute> var1);

        public Builder resourceAttributeList(ResourceAttribute ... var1);

        public Builder resourceAttributeList(Consumer<ResourceAttribute.Builder> ... var1);
    }
}

