/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttribute;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutResourceAttributesRequest
extends MigrationHubRequest
implements ToCopyableBuilder<Builder, PutResourceAttributesRequest> {
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final List<ResourceAttribute> resourceAttributeList;
    private final Boolean dryRun;

    private PutResourceAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.resourceAttributeList = builder.resourceAttributeList;
        this.dryRun = builder.dryRun;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public List<ResourceAttribute> resourceAttributeList() {
        return this.resourceAttributeList;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourceAttributesRequest)) {
            return false;
        }
        PutResourceAttributesRequest other = (PutResourceAttributesRequest)((Object)obj);
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.resourceAttributeList(), other.resourceAttributeList()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"PutResourceAttributesRequest").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("ResourceAttributeList", this.resourceAttributeList()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.of(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.of(clazz.cast(this.migrationTaskName()));
            }
            case "ResourceAttributeList": {
                return Optional.of(clazz.cast(this.resourceAttributeList()));
            }
            case "DryRun": {
                return Optional.of(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MigrationHubRequest.BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private List<ResourceAttribute> resourceAttributeList;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourceAttributesRequest model) {
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.resourceAttributeList(model.resourceAttributeList);
            this.dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final Collection<ResourceAttribute.Builder> getResourceAttributeList() {
            return this.resourceAttributeList != null ? (Collection)this.resourceAttributeList.stream().map(ResourceAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList) {
            this.resourceAttributeList = ResourceAttributeListCopier.copy(resourceAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(ResourceAttribute ... resourceAttributeList) {
            this.resourceAttributeList(Arrays.asList(resourceAttributeList));
            return this;
        }

        public final void setResourceAttributeList(Collection<ResourceAttribute.BuilderImpl> resourceAttributeList) {
            this.resourceAttributeList = ResourceAttributeListCopier.copyFromBuilder(resourceAttributeList);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutResourceAttributesRequest build() {
            return new PutResourceAttributesRequest(this);
        }
    }

    public static interface Builder
    extends MigrationHubRequest.Builder,
    CopyableBuilder<Builder, PutResourceAttributesRequest> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder resourceAttributeList(Collection<ResourceAttribute> var1);

        public Builder resourceAttributeList(ResourceAttribute ... var1);

        public Builder dryRun(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

