/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportMigrationTaskRequest
extends MigrationHubRequest
implements ToCopyableBuilder<Builder, ImportMigrationTaskRequest> {
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final Boolean dryRun;

    private ImportMigrationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.dryRun = builder.dryRun;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportMigrationTaskRequest)) {
            return false;
        }
        ImportMigrationTaskRequest other = (ImportMigrationTaskRequest)((Object)obj);
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"ImportMigrationTaskRequest").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.of(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.of(clazz.cast(this.migrationTaskName()));
            }
            case "DryRun": {
                return Optional.of(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MigrationHubRequest.BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportMigrationTaskRequest model) {
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportMigrationTaskRequest build() {
            return new ImportMigrationTaskRequest(this);
        }
    }

    public static interface Builder
    extends MigrationHubRequest.Builder,
    CopyableBuilder<Builder, ImportMigrationTaskRequest> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder dryRun(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

